/*
 * Decompiled with CFR 0.152.
 */
package secauth;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import secauth.a2;
import secauth.a5;
import secauth.aet;
import secauth.afb;
import secauth.akk;
import secauth.cia;
import secauth.cih;
import secauth.cv;
import secauth.eu;
import secauth.fq;
import secauth.ft;
import secauth.n3;

public class fo
extends fq {
    private String a;
    private Long b;
    private Date c;
    private Date d;

    public fo(byte[] byArray, afb[] afbArray, Set<a5> set, ZipOutputStream zipOutputStream) throws ParseException, ft {
        this(cih.a(byArray, byArray.length, null), afbArray, set, zipOutputStream);
    }

    private fo(cia cia2, afb[] afbArray, Set<a5> set, ZipOutputStream zipOutputStream) throws ParseException, ft {
        super(null, cia2, afbArray, "http://uri.etsi.org/TrstSvc/TrustedList/TSLType/EUgeneric");
        cia cia3;
        cia cia4 = cia2.c("SchemeInformation");
        if (null == cia4) {
            throw new ParseException("Member state's trust service list does not contain SchemeInformation.", 0);
        }
        cia cia5 = cia4.c("SchemeTerritory");
        if (null == cia5 || cia5.h() == null) {
            throw new ParseException("Member state's trust service list does not contain SchemeTerritory.", 0);
        }
        this.a = cia5.h();
        cia cia6 = cia4.c("TSLSequenceNumber");
        if (null == cia6 || cia6.h() == null) {
            throw new ParseException("Member state's trust service list does not contain TSLSequenceNumber.", 0);
        }
        try {
            this.b = Long.valueOf(cia6.h());
        }
        catch (Exception exception) {
            n3.a(exception);
            throw new ParseException("Member state's trust service list contain the TSLSequenceNumber " + cia6 + " which cannot be parsed: " + exception.getMessage(), 0);
        }
        cia cia7 = cia4.c("ListIssueDateTime");
        if (null == cia7 || cia7.h() == null) {
            throw new ParseException("Member state's trust service list does not contain ListIssueDateTime.", 0);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        this.c = simpleDateFormat.parse(cia7.h());
        cia cia8 = cia4.c("NextUpdate");
        cia cia9 = cia3 = null != cia8 ? cia8.c("dateTime") : null;
        if (null == cia3 || cia3.h() == null) {
            n3.b("Member state's trust service list does not contain NextUpdate dateTime.");
        } else {
            this.d = simpleDateFormat.parse(cia3.h());
        }
        cia cia10 = cia2.c("TrustServiceProviderList");
        if (null == cia10) {
            n3.b("Member state's trust service list does not contain TrustServiceProviderList.");
        } else {
            cia[] ciaArray = cia10.d("TrustServiceProvider");
            if (null == ciaArray) {
                throw new ParseException("Member state's trust service list does not contain any TrustServiceProvider.", 0);
            }
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
            for (cia cia11 : ciaArray) {
                cia cia12 = cia11.c("TSPInformation");
                if (null == cia12) {
                    throw new ParseException("Member state's trust service list does not contain TSPInformation in a TrustServiceProvider.", 0);
                }
                cia cia13 = cia12.c("TSPName");
                if (null == cia13) {
                    throw new ParseException("Member state's trust service list does not contain TSPName in a TSPInformation.", 0);
                }
                cia[] ciaArray2 = cia13.d("Name");
                if (null == ciaArray2) {
                    throw new ParseException("Member state's trust service list does not contain any name in a TSPName in a TSPInformation.", 0);
                }
                String string = ciaArray2[0].h();
                n3.f("Trust service provider: " + string);
                long l10 = this.a(string, true);
                long l11 = this.a(string, false);
                boolean bl10 = false;
                boolean bl11 = false;
                cia cia14 = cia11.c("TSPServices");
                if (null == cia14) {
                    throw new ParseException("Member state's trust service list does not contain TSPServices in a TrustServiceProvider.", 0);
                }
                cia[] ciaArray3 = cia14.d("TSPService");
                if (null == ciaArray3) {
                    throw new ParseException("Member state's trust service list does not contain TSPService in TSPServices of " + string + ".", 0);
                }
                TreeSet<Object> treeSet = new TreeSet<Object>();
                for (cia cia15 : ciaArray3) {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    int n10;
                    int n11;
                    Object object6;
                    cia cia16 = cia15.c("ServiceInformation");
                    if (null == cia16) {
                        throw new ParseException("Member state's trust service list does not contain ServiceInformation in TSPServices of '" + string + "'.", 0);
                    }
                    cia cia17 = cia16.c("ServiceName");
                    if (null == cia17) {
                        throw new ParseException("Member state's trust service list does not contain ServiceName in a TSPService of '" + string + "'.", 0);
                    }
                    cia[] ciaArray4 = cia17.d("Name");
                    if (null == ciaArray4) {
                        throw new ParseException("Member state's trust service list does not contain any name in a ServiceName in a TSPService of '" + string + "'.", 0);
                    }
                    String string2 = ciaArray4[0].h();
                    n3.f("Service name: " + string2);
                    a[] aArray = null;
                    cia cia18 = cia15.c("ServiceHistory");
                    if (null != cia18) {
                        object6 = cia18.d("ServiceHistoryInstance");
                        int n12 = n11 = null == object6 ? 0 : ((cia[])object6).length;
                        if (0 < n11) {
                            aArray = new a[n11];
                            for (n10 = 0; n10 < n11; ++n10) {
                                object5 = object6[n10];
                                object4 = ((cia)object5).c("ServiceStatus");
                                if (null == object4 || ((cia)object4).h() == null) {
                                    throw new ParseException("Member state's trust service list does not contain ServiceStatus in the " + n10 + ".th ServiceHistoryInstance of TSPServices of '" + string2 + "'.", 0);
                                }
                                object3 = ((cia)object4).h().trim();
                                object2 = ((cia)object5).c("StatusStartingTime");
                                if (null == object2 || ((cia)object2).h() == null) {
                                    throw new ParseException("Member state's trust service list does not contain StatusStartingTime in TSPServices in the " + n10 + ".th ServiceHistoryInstance of TSPServices of '" + string2 + "'.", 0);
                                }
                                object = simpleDateFormat.parse(((cia)object2).h());
                                aArray[n10] = new a((Date)object, (String)object3);
                            }
                        }
                    }
                    if (null == (object6 = cia16.c("ServiceTypeIdentifier")) || ((cia)object6).h() == null) {
                        throw new ParseException("Member state's trust service list does not contain ServiceTypeIdentifier in TSPServices of '" + string2 + "'.", 0);
                    }
                    n11 = 0;
                    n10 = 0;
                    object5 = ((cia)object6).h();
                    if ("http://uri.etsi.org/TrstSvc/Svctype/CA/QC".equals(object5)) {
                        n11 = 1;
                    } else if (!"http://uri.etsi.org/TrstSvc/Svctype/ACA".equals(object5)) {
                        if ("http://uri.etsi.org/TrstSvc/Svctype/NationalRootCA-QC".equals(object5)) {
                            n11 = 1;
                        } else if (!"http://uri.etsi.org/TrstSvc/Svctype/Certstatus/CRL".equals(object5)) {
                            if ("http://uri.etsi.org/TrstSvc/Svctype/Certstatus/OCSP/QC".equals(object5)) {
                                n11 = 1;
                            } else if ("http://uri.etsi.org/TrstSvc/Svctype/Certstatus/OCSP".equals(object5)) {
                                n10 = 1;
                            } else if ("http://uri.etsi.org/TrstSvc/Svctype/TSA".equals(object5)) {
                                n10 = 1;
                            } else if ("http://uri.etsi.org/TrstSvc/Svctype/TSA/QTST".equals(object5)) {
                                n11 = 1;
                            } else if (!("http://uri.etsi.org/TrstSvc/Svctype/TSA/TSS-QC".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/TSA/TSS-AdESQCandQES".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/Archiv".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/TLIssuer".equals(object5) || "http://uri.etsi.org/TrstSvd/Svctype/TLIssuer".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/PSES/Q".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/EDS/Q".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/unspecified".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/RA".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/SignaturePolicyAuthority".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/CA/PKC".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/EDS/REM/Q".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/IdV".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/IdV/nothavingPKIid".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/QESValidation/Q".equals(object5))) {
                                if ("http://uri.etsi.org/TrstSvc/Svctype/Certstatus/CRL/QC".equals(object5)) {
                                    n11 = 1;
                                } else if (!("http://uri.etsi.org/TrstSvc/Svctype/RemoteQSCDManagement/Q".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/EDS".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/EDS/REM".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/PSES".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/AdESValidation".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/AdESGeneration".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/RA/nothavingPKIid".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/Archiv/nothavingPKIid".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/KEscrow".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/KEscrow/nothavingPKIid".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/PPwd".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/PPwd/nothavingPKIid".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/RemoteQSigCDManagement/Q".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/RemoteQSealCDManagement/Q".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/EAA/Q".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/ElectronicArchiving/Q".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/Ledgers/Q".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/RemoteSigCDManagement".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/RemoteSealCDManagement".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/EAA".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/ElectronicArchiving".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/Ledgers".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/PKCValidation".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/PKCPreservation".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/EAAValidation".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/TSTValidation".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/EDSValidation".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/EAA/Pub-EAA".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/CA/PKC/CertsforOtherTypesOfTS".equals(object5) || "http://uri.etsi.org/TrstSvc/Svctype/PKCValidation/CertsforOtherTypesOfTS".equals(object5))) {
                                    throw new ParseException("Member state's trust service list contains the unsupported service type " + (String)object5 + " in TSPServices of '" + string2 + "'.", 0);
                                }
                            }
                        }
                    }
                    if (n11 == 0 && n10 == 0) {
                        n3.f("Ignoring the service '" + string2 + "' since its type '" + (String)object5 + "' is not relevant for qualified signatures.");
                        continue;
                    }
                    object4 = ((String)object5).substring("http://uri.etsi.org/TrstSvc/Svctype/".length());
                    object4 = ((String)object4).replace('/', '_');
                    object3 = cia16.c("ServiceStatus");
                    if (null == object3 || ((cia)object3).h() == null) {
                        throw new ParseException("Member state's trust service list does not contain ServiceStatus in TSPServices of '" + string2 + "'.", 0);
                    }
                    object2 = ((cia)object3).h().trim();
                    object = cia16.c("StatusStartingTime");
                    if (null == object || ((cia)object).h() == null) {
                        throw new ParseException("Member state's trust service list does not contain the current StatusStartingTime in TSPServices of '" + string2 + "'.", 0);
                    }
                    Date date = simpleDateFormat.parse(((cia)object).h());
                    Date date2 = null;
                    if (!fo.a((String)object2, string2)) {
                        date2 = date;
                        if (null == aArray) {
                            n3.b("Ignoring the withdrawn TSPService of '" + string2 + "'. because it does not contain any previous status.");
                            n11 = 0;
                            n10 = 0;
                        } else {
                            boolean bl12 = false;
                            for (a a100 : aArray) {
                                if (fo.a(a100.b(), string2)) {
                                    bl12 = true;
                                    break;
                                }
                                date2 = a100.a();
                            }
                            if (!bl12) {
                                throw new ParseException("Member state's trust service list does not contain any historic state during which the withdrawn TSPService of '" + string2 + "' has been active.", 0);
                            }
                        }
                    }
                    if (n11 == 0 && n10 == 0) continue;
                    cia cia19 = cia16.c("ServiceDigitalIdentity");
                    if (null == cia19) {
                        throw new ParseException("Member state's trust service list does not contain ServiceDigitalIdentity in TSPServices of '" + string2 + "'.", 0);
                    }
                    Object[] objectArray = cia19.d("DigitalId");
                    if (null == objectArray) {
                        n3.b("Member state's trust service list does not contain any DigitalId in ServiceDigitalIdentity of " + string2 + ".");
                        continue;
                    }
                    for (Object object7 : objectArray) {
                        String string3;
                        Object object8;
                        afb afb2;
                        cia cia20 = ((cia)object7).c("X509Certificate");
                        if (null == cia20) continue;
                        String string4 = cia20.h();
                        byte[] byArray = cv.b(string4);
                        eu eu2 = new eu();
                        eu2.a(byArray);
                        try {
                            afb2 = new afb(byArray);
                        }
                        catch (Exception exception) {
                            n3.a(exception);
                            n3.b("Ignoring the invalid X.509 certificate found in ServiceDigitalIdentity of " + string2 + " in a member state's trust service list: " + exception.getMessage());
                            object8 = akk.f();
                            if (null == object8) continue;
                            ((akk)object8).a(byArray, exception.getMessage());
                            continue;
                        }
                        String string5 = afb2.e().y();
                        if (!set.add(new a5(byArray))) {
                            n3.b("TSPService '" + string5 + "' found twice in trusted lists.");
                            continue;
                        }
                        object8 = "countries-TL/" + this.a + "/" + fo.a(string) + "/" + (String)object4;
                        if (treeSet.add(object8)) {
                            string3 = (String)object8 + "/trustedcaid.txt";
                            try {
                                zipOutputStream.putNextEntry(new ZipEntry(string3));
                                zipOutputStream.write(((n11 != 0 ? l10 : l11) + "\r\n").getBytes(StandardCharsets.UTF_8));
                                zipOutputStream.closeEntry();
                            }
                            catch (IOException iOException) {
                                n3.a(iOException);
                                throw new ParseException("Could not write trustedcaid.txt to " + string3 + ": " + iOException.getMessage(), 0);
                            }
                        }
                        string3 = (String)object8 + "/" + fo.a(simpleDateFormat2, afb2);
                        String string6 = "Putting the trust service provider's certificate of '" + string5 + "' into the cert batch ZIP as " + string3 + ".";
                        if (null != date2) {
                            string6 = string6 + " The certificate has been revoked at " + date2;
                        }
                        n3.f(string6);
                        try {
                            zipOutputStream.putNextEntry(new ZipEntry(string3));
                            zipOutputStream.write(byArray);
                            zipOutputStream.closeEntry();
                        }
                        catch (IOException iOException) {
                            n3.a(iOException);
                            throw new ParseException("Could not put the trust service provider's certificate at " + string3 + " in the cert stack ZIP: " + iOException.getMessage(), 0);
                        }
                        if (null != date2) {
                            try {
                                zipOutputStream.putNextEntry(new ZipEntry(string3 + ".revoked"));
                                zipOutputStream.write(simpleDateFormat.format(date2).getBytes(StandardCharsets.UTF_8));
                                zipOutputStream.closeEntry();
                            }
                            catch (IOException iOException) {
                                n3.a(iOException);
                                throw new ParseException("Could not put the revocation date of the trust service provider's certificate at " + string3 + " in the cert stack ZIP: " + iOException.getMessage(), 0);
                            }
                        }
                        if (n11 != 0) {
                            bl10 = true;
                            continue;
                        }
                        bl11 = true;
                    }
                }
                if (bl10) {
                    this.a(string, l10, true, zipOutputStream);
                }
                if (!bl11) continue;
                this.a(string, l11, false, zipOutputStream);
            }
        }
    }

    private final long a(String string, boolean bl10) {
        String string2 = this.a + string;
        if (!bl10) {
            string2 = string2 + "#advanced";
        }
        eu eu2 = new eu();
        eu2.a(string2.getBytes(StandardCharsets.UTF_8));
        byte[] byArray = eu2.m();
        long l10 = (long)a2.g(byArray, 0) & Integer.MAX_VALUE;
        if (l10 < 10000L) {
            l10 ^= Integer.MAX_VALUE;
        }
        return l10;
    }

    private final void a(String string, long l10, boolean bl10, ZipOutputStream zipOutputStream) throws ParseException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.UTF_8));
            bufferedWriter.write("name=" + string + "\r\n");
            bufferedWriter.write("description=" + string + ", " + (bl10 ? "qualified" : "advanced") + " signature, " + this.a + "\r\n");
            bufferedWriter.write("sigcontext=" + (bl10 ? aet.a(this.a) : aet.b(this.a)) + "\r\n");
            ((Writer)bufferedWriter).close();
            zipOutputStream.putNextEntry(new ZipEntry("caconf/" + l10 + "/ca.properties"));
            zipOutputStream.write(byteArrayOutputStream.toByteArray());
            zipOutputStream.closeEntry();
        }
        catch (IOException iOException) {
            n3.a(iOException);
            throw new ParseException("Could not write UTF-8 ca.properties for the trust service provider " + string + " to the ZIP: " + iOException.getMessage(), 0);
        }
    }

    private static boolean a(String string, String string2) throws ParseException {
        if ("http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/accredited".equals(string) || "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/setbynationallaw".equals(string) || "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/undersupervision".equals(string) || "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/supervisionincessation".equals(string) || "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/granted".equals(string) || "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/recognisedatnationallevel".equals(string)) {
            return true;
        }
        if ("http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/accreditationrevoked".equals(string) || "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/supervisionceased".equals(string) || "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/accreditationceased".equals(string) || "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/supervisionrevoked".equals(string) || "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/withdrawn".equals(string) || "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/deprecatedatnationallevel".equals(string)) {
            return false;
        }
        throw new ParseException("Member state's trust service list contains the unknown ServiceStatus " + string + " in TSPServices of '" + string2 + "'.", 0);
    }

    public String a() {
        return this.a;
    }

    public Long b() {
        return this.b;
    }

    public Date c() {
        return this.c;
    }

    public Date d() {
        return this.d;
    }

    public static String a(DateFormat dateFormat, afb afb2) {
        String string = afb2.b();
        string = null == string ? afb2.e().g() : string;
        String string2 = fo.a(string = null == string ? afb2.e().h() : string);
        if (string2.endsWith(":PN")) {
            string2 = string2.substring(0, string2.length() - 3);
        }
        return dateFormat.format(afb2.q()) + "-" + string2 + "-" + afb2.o().toString(16) + ".der";
    }

    private static String a(String string) {
        return string.replace(' ', '_').replace('(', '_').replace(')', '_').replace(',', '_').replace('\u00e9', 'e').replace('*', '_').replace('\'', '_').replace('\u00f4', 'o').replace('\u00f6', 'o').replace('\u00e1', 'a').replace('\u00fa', 'u').replace('\u00ed', 'i').replace('\u00f3', 'o').replace('\u00e7', 'c').replace('/', '_');
    }

    class a {
        private Date a;
        private String b;

        public a(Date date, String string) {
            this.a = date;
            this.b = string;
        }

        public Date a() {
            return this.a;
        }

        public String b() {
            return this.b;
        }
    }
}

