/*
 * Decompiled with CFR 0.152.
 */
package secauth;

import java.io.IOException;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.TreeSet;
import secauth.a2;
import secauth.acx;
import secauth.adi;
import secauth.aji;
import secauth.c7;
import secauth.cia;
import secauth.d9;
import secauth.e4;
import secauth.eq;
import secauth.n3;

public final class en
extends c7 {
    private static TreeSet<eq> a;

    public static boolean a(byte[] byArray, byte[] byArray2, int n10, acx acx2, e4 e42) {
        int n11 = e42.a().bitLength();
        if (n11 % 8 != 0) {
            n3.a("The RSA signature to verify has a modulus length of " + n11 + " bits. However, only multiples of 8 are supported.");
            return false;
        }
        BigInteger bigInteger = new BigInteger(1, byArray);
        byte[] byArray3 = bigInteger.modPow(e42.b(), e42.a()).toByteArray();
        try {
            byArray3 = a2.d(byArray3, n11 / 8);
        }
        catch (IOException iOException) {
            n3.a(iOException, "Extending the decrypted RSA signature to the modulus length failed");
        }
        if (n10 > 0) {
            try {
                adi.a(acx2, byArray2, byArray3, n10);
                return true;
            }
            catch (Exception exception) {
                n3.f("EMSA-PSS-VERIFY failed: " + exception.getMessage());
                return false;
            }
        }
        try {
            byte[] byArray4 = adi.a(byArray3, acx2);
            return Arrays.equals(byArray2, byArray4);
        }
        catch (ParseException parseException) {
            n3.f("PKCS#1 v1.5 padding check failed: " + parseException.getMessage());
            try {
                byte[] byArray5 = d9.b(byArray3, byArray2.length);
                boolean bl10 = Arrays.equals(byArray2, byArray5);
                if (bl10) {
                    n3.f("Found ISO 9796-2 padding.");
                }
                return bl10;
            }
            catch (ParseException parseException2) {
                n3.f("PKCS#1 and ISO 9796-2 padding check failed. Signature checked with wrong cert or invalid: " + parseException2.getMessage());
                return false;
            }
        }
    }

    @Override
    public String b() {
        return "RSA";
    }

    @Override
    public String a() {
        return aji.b(90000073);
    }

    @Override
    public int c() {
        return 6029;
    }

    public static void a(cia[] ciaArray) throws ParseException {
        a = new TreeSet();
        for (cia cia2 : ciaArray) {
            Date date;
            int n10;
            cia cia3 = cia2.c("Mod");
            if (null == cia3) {
                throw new ParseException("Parameter modulus length missing in RSA parameters in algorithm catalog", 0);
            }
            try {
                n10 = Integer.parseInt(cia3.m());
            }
            catch (Exception exception) {
                throw new ParseException("Parameter modulus length '" + cia3.m() + "' in RSA parameters in algorithm catalog is no integer.", 0);
            }
            cia cia4 = cia2.c("ValidUntil");
            if (null == cia4) {
                throw new ParseException("Parameter ValidUntil missing in RSA parameters in algorithm catalog", 0);
            }
            String string = cia4.m();
            if (null == string) {
                throw new ParseException("Parameter ValidUntil is empty in RSA parameters in algorithm catalog", 0);
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            try {
                date = simpleDateFormat.parse(string);
            }
            catch (Exception exception) {
                throw new ParseException("Parameter ValidUntil '" + string + "' does not contain a date in RSA parameters in algorithm catalog: " + exception.getMessage(), 0);
            }
            n3.f("RSA with a minimum bit length of the modulus of " + n10 + " will loose its evidence value for qualified eIDAS signatures at " + date + ".");
            a.add(new eq(n10, date));
        }
    }

    @Override
    public Date a(int n10, int n11) {
        if (null != a) {
            Iterator<eq> iterator = a.descendingIterator();
            while (iterator.hasNext()) {
                eq eq2 = iterator.next();
                if (n10 < eq2.a()) continue;
                return eq2.b();
            }
        }
        if (n10 >= 3000) {
            return new GregorianCalendar(2031, 0, 1).getTime();
        }
        if (n10 >= 1900) {
            return new GregorianCalendar(2026, 0, 1).getTime();
        }
        if (n10 >= 1728) {
            return new GregorianCalendar(2011, 0, 1).getTime();
        }
        if (n10 >= 1536) {
            return new GregorianCalendar(2010, 0, 1).getTime();
        }
        if (n10 >= 1280) {
            return new GregorianCalendar(2009, 0, 1).getTime();
        }
        if (n10 >= 1024) {
            return new GregorianCalendar(2008, 3, 1).getTime();
        }
        if (n10 >= 768) {
            return new GregorianCalendar(2001, 0, 1).getTime();
        }
        return new GregorianCalendar(1700, 0, 1).getTime();
    }
}

