/*
 * Decompiled with CFR 0.152.
 */
package seccommerce.smartcard.pkcs11;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import secauth.b8j;
import secauth.g0;
import secauth.n3;
import seccommerce.smartcard.pkcs11.Pkcs11Exception;
import seccommerce.smartcard.pkcs11.Pkcs11KeyInfo;
import seccommerce.smartcard.pkcs11.Pkcs11TokenInfo;

public class Pkcs11 {
    private static Map<String, Pkcs11> pkcs11Map = Collections.synchronizedMap(new HashMap());
    private int libParamIndex;

    public static Pkcs11 createPkcs11(String string) throws Pkcs11Exception {
        Pkcs11 pkcs11 = pkcs11Map.get(string);
        if (null == pkcs11) {
            n3.c("PKCS#11 cInitialize at " + string);
            pkcs11 = new Pkcs11(string);
            pkcs11Map.put(string, pkcs11);
        }
        return pkcs11;
    }

    private Pkcs11(String string) throws Pkcs11Exception {
        new g0();
        try {
            this.libParamIndex = this.cInitialize(string);
        }
        catch (Pkcs11Exception pkcs11Exception) {
            if (pkcs11Exception.getPkcs11ReturnCode() == 401) {
                System.out.println("PKCS#11 ignored: " + pkcs11Exception);
            }
            throw pkcs11Exception;
        }
    }

    private native int cInitialize(String var1) throws Pkcs11Exception;

    public void cFinalize() throws Pkcs11Exception {
        Pkcs11 pkcs11 = this;
        pkcs11.cFinalize(pkcs11.libParamIndex);
    }

    private native void cFinalize(int var1) throws Pkcs11Exception;

    public String cGetInfo() throws Pkcs11Exception {
        Pkcs11 pkcs11 = this;
        return pkcs11.cGetInfo(pkcs11.libParamIndex);
    }

    private native String cGetInfo(int var1) throws Pkcs11Exception;

    public String getReaderInfo(long l10) throws Pkcs11Exception {
        Pkcs11 pkcs11 = this;
        return pkcs11.getReaderInfo(pkcs11.libParamIndex, l10);
    }

    private native String getReaderInfo(int var1, long var2) throws Pkcs11Exception;

    public void cInitToken(long l10, byte[] byArray, byte[] byArray2) throws Pkcs11Exception {
        Pkcs11 pkcs11 = this;
        pkcs11.cInitToken(pkcs11.libParamIndex, l10, byArray, byArray2);
    }

    private native void cInitToken(int var1, long var2, byte[] var4, byte[] var5) throws Pkcs11Exception;

    public void cInitPIN(long l10, byte[] byArray) throws Pkcs11Exception {
        Pkcs11 pkcs11 = this;
        pkcs11.cInitPIN(pkcs11.libParamIndex, l10, byArray);
    }

    private native void cInitPIN(int var1, long var2, byte[] var4) throws Pkcs11Exception;

    public void cSetPIN(long l10, byte[] byArray, byte[] byArray2) throws Pkcs11Exception {
        Pkcs11 pkcs11 = this;
        pkcs11.cSetPIN(pkcs11.libParamIndex, l10, byArray, byArray2);
    }

    private native void cSetPIN(int var1, long var2, byte[] var4, byte[] var5) throws Pkcs11Exception;

    public long[] cGetSlotList(boolean bl10) throws Pkcs11Exception {
        Pkcs11 pkcs11 = this;
        return pkcs11.cGetSlotList(pkcs11.libParamIndex, bl10);
    }

    private native long[] cGetSlotList(int var1, boolean var2) throws Pkcs11Exception;

    public Pkcs11TokenInfo getTokenInfo(long l10) throws Pkcs11Exception {
        Pkcs11 pkcs11 = this;
        return pkcs11.getTokenInfo(pkcs11.libParamIndex, l10);
    }

    private native Pkcs11TokenInfo getTokenInfo(int var1, long var2) throws Pkcs11Exception;

    public int cGetTokenMinPinLength(long l10) throws Pkcs11Exception {
        Pkcs11 pkcs11 = this;
        return pkcs11.cGetTokenMinPinLength(pkcs11.libParamIndex, l10);
    }

    private native int cGetTokenMinPinLength(int var1, long var2) throws Pkcs11Exception;

    public int cGetTokenMaxPinLength(long l10) throws Pkcs11Exception {
        Pkcs11 pkcs11 = this;
        return pkcs11.cGetTokenMaxPinLength(pkcs11.libParamIndex, l10);
    }

    private native int cGetTokenMaxPinLength(int var1, long var2) throws Pkcs11Exception;

    public boolean tokenPresent(long l10) throws Pkcs11Exception {
        Pkcs11 pkcs11 = this;
        return pkcs11.tokenPresent(pkcs11.libParamIndex, l10);
    }

    private native boolean tokenPresent(int var1, long var2) throws Pkcs11Exception;

    public long cOpenSession(long l10, long l11) throws Pkcs11Exception {
        Pkcs11 pkcs11 = this;
        return pkcs11.cOpenSession(pkcs11.libParamIndex, l10, l11);
    }

    private native long cOpenSession(int var1, long var2, long var4) throws Pkcs11Exception;

    public void cCloseSession(long l10) throws Pkcs11Exception {
        Pkcs11 pkcs11 = this;
        pkcs11.cCloseSession(pkcs11.libParamIndex, l10);
    }

    private native void cCloseSession(int var1, long var2) throws Pkcs11Exception;

    public void cLogin(long l10, long l11, byte[] byArray) throws Pkcs11Exception {
        Pkcs11 pkcs11 = this;
        pkcs11.cLogin(pkcs11.libParamIndex, l10, l11, byArray);
    }

    private native void cLogin(int var1, long var2, long var4, byte[] var6) throws Pkcs11Exception;

    public void cLogout(long l10) throws Pkcs11Exception {
        Pkcs11 pkcs11 = this;
        pkcs11.cLogout(pkcs11.libParamIndex, l10);
    }

    private native void cLogout(int var1, long var2) throws Pkcs11Exception;

    public void createCertObject(long l10, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) throws Pkcs11Exception {
        Pkcs11 pkcs11 = this;
        pkcs11.createCertObject(pkcs11.libParamIndex, l10, byArray, byArray2, byArray3, byArray4, byArray5, byArray6);
    }

    private native void createCertObject(int var1, long var2, byte[] var4, byte[] var5, byte[] var6, byte[] var7, byte[] var8, byte[] var9) throws Pkcs11Exception;

    public byte[][] findObjects(long l10, long l11) throws Pkcs11Exception {
        Pkcs11 pkcs11 = this;
        return pkcs11.findObjects(pkcs11.libParamIndex, l10, l11);
    }

    private native byte[][] findObjects(int var1, long var2, long var4) throws Pkcs11Exception;

    public byte[] signWithKeyIndex(long l10, byte[] byArray, int n10) throws Pkcs11Exception {
        Pkcs11 pkcs11 = this;
        return pkcs11.signWithKeyIndex(pkcs11.libParamIndex, l10, byArray, n10);
    }

    private native byte[] signWithKeyIndex(int var1, long var2, byte[] var4, int var5) throws Pkcs11Exception;

    public byte[] sign(long l10, long l11, byte[] byArray, long l12) throws Pkcs11Exception {
        Pkcs11 pkcs11 = this;
        return pkcs11.sign(pkcs11.libParamIndex, l10, l11, byArray, l12);
    }

    private native byte[] sign(int var1, long var2, long var4, byte[] var6, long var7) throws Pkcs11Exception;

    public byte[] decrypt(long l10, byte[] byArray, int n10) throws Pkcs11Exception {
        Pkcs11 pkcs11 = this;
        return pkcs11.decrypt(pkcs11.libParamIndex, l10, byArray, n10);
    }

    private native byte[] decrypt(int var1, long var2, byte[] var4, int var5) throws Pkcs11Exception;

    public void genRandom(long l10, byte[] byArray) throws Pkcs11Exception {
        Pkcs11 pkcs11 = this;
        pkcs11.genRandom(pkcs11.libParamIndex, l10, byArray);
    }

    private native void genRandom(int var1, long var2, byte[] var4) throws Pkcs11Exception;

    public boolean isSecurePin(long l10) throws Pkcs11Exception {
        Pkcs11 pkcs11 = this;
        return pkcs11.isSecurePin(pkcs11.libParamIndex, l10);
    }

    private native boolean isSecurePin(int var1, long var2) throws Pkcs11Exception;

    public Pkcs11KeyInfo cGenerateKeyPair(long l10, byte[] byArray, int n10, byte[] byArray2, byte[] byArray3) throws Pkcs11Exception {
        Pkcs11 pkcs11 = this;
        return pkcs11.cGenerateKeyPair(pkcs11.libParamIndex, l10, byArray, n10, byArray2, byArray3);
    }

    private native Pkcs11KeyInfo cGenerateKeyPair(int var1, long var2, byte[] var4, int var5, byte[] var6, byte[] var7) throws Pkcs11Exception;

    public byte[] etcDeviceIoctl(long l10, long l11, byte[] byArray) throws Pkcs11Exception {
        Pkcs11 pkcs11 = this;
        return pkcs11.etcDeviceIoctl(pkcs11.libParamIndex, l10, l11, byArray);
    }

    private native byte[] etcDeviceIoctl(int var1, long var2, long var4, byte[] var6) throws Pkcs11Exception;

    public native b8j[] getMsCryptProvContainerInfo() throws Pkcs11Exception;

    private native void unloadLib(int var1);

    private void unloadLib() {
        Pkcs11 pkcs11 = this;
        pkcs11.unloadLib(pkcs11.libParamIndex);
    }

    public static void unloadAllLibs() {
        pkcs11Map.values().forEach(Pkcs11::unloadLib);
    }
}

