/*
 * Decompiled with CFR 0.152.
 */
package seccommerce.common;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import secauth.cd;
import secauth.n3;

public class PropertyUtil
extends Properties {
    private static final long serialVersionUID = -4875053833533239601L;
    private List<String> a = Collections.synchronizedList(new ArrayList());
    private byte[] b;
    private String c;
    private String d;
    private Properties e;

    public PropertyUtil() {
    }

    public PropertyUtil(@NotNull Properties properties) {
        Objects.requireNonNull(properties, "Properties parameter is null.");
        for (String string : properties.stringPropertyNames()) {
            String string2 = properties.getProperty(string);
            this.put(string, string2);
        }
    }

    public PropertyUtil(String string) throws IOException, FileNotFoundException {
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[(int)file.length()];
        fileInputStream.read(byArray);
        fileInputStream.close();
        this.d = file.getName();
        this.c = file.getAbsolutePath();
        this.b = byArray;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.b);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)byteArrayInputStream, StandardCharsets.UTF_8));
        this.load(bufferedReader);
        ((InputStream)byteArrayInputStream).close();
    }

    public PropertyUtil(InputStream inputStream) throws IOException {
        this.load(inputStream);
        String string = this.getProperty("clientproperties");
        if (null != string) {
            n3.c("Client properties are given: " + string);
            char[] cArray = new char[]{';', ','};
            String[] stringArray = cd.b(string, cArray);
            int n10 = null == stringArray ? 0 : stringArray.length;
            for (int i10 = 0; i10 < n10; ++i10) {
                String string2 = cd.r(stringArray[i10]);
                n3.c("Loading client properties from " + string2);
                PropertyUtil propertyUtil = new PropertyUtil(string2);
                for (Map.Entry<Object, Object> entry : propertyUtil.entrySet()) {
                    Object object = entry.getKey();
                    Object object2 = entry.getValue();
                    if (this.containsKey(object)) {
                        String string3 = (String)this.get(object);
                        if (string3.equalsIgnoreCase((String)object2)) {
                            n3.c("Key " + object + " is set as " + object2 + " in several configuration files.");
                            continue;
                        }
                        throw new IOException("Key " + object + " is set in several configuration files with different values (" + string3 + " and " + object2 + ").");
                    }
                    this.put(object, object2);
                }
            }
        }
    }

    public void mergePropertyUtil(File file) throws IOException, FileNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.load(fileInputStream);
        ((InputStream)fileInputStream).close();
    }

    public void setPriorityProperties(Properties properties) {
        this.e = properties;
    }

    public int getPropertyInt(String string, int n10) {
        String string2 = this.getProperty(string);
        if (null != string2) {
            try {
                return Integer.parseInt(string2);
            }
            catch (Exception exception) {
                n3.b("Invalid int value \"" + string2 + "\" at property \"" + string + "\".");
            }
        }
        return n10;
    }

    public int getPropertyInt(String[] stringArray, int n10) {
        for (String string : stringArray) {
            int n11 = this.getPropertyInt(string, Integer.MIN_VALUE);
            if (n11 == Integer.MIN_VALUE) continue;
            return n11;
        }
        return n10;
    }

    public float getPropertyFloat(String string, float f10) {
        String string2 = this.getProperty(string);
        if (null != string2) {
            try {
                return Float.parseFloat(string2);
            }
            catch (Exception exception) {
                n3.b("Invalid float value \"" + string2 + "\" at property \"" + string + "\".");
            }
        }
        return f10;
    }

    public Color getPropertyColor(String string) {
        return this.getPropertyColor(string, null);
    }

    public Color getPropertyColor(String string, Color color) {
        String string2 = this.getProperty(string);
        if (null != string2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            try {
                String string3 = cd.r(stringTokenizer.nextToken());
                String string4 = cd.r(stringTokenizer.nextToken());
                String string5 = cd.r(stringTokenizer.nextToken());
                return new Color(Integer.parseInt(string3), Integer.parseInt(string4), Integer.parseInt(string5));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return color;
    }

    public String getPropertyFilenameExt(String string, String string2) {
        return cd.c(this.getProperty(string, string2), "*", "");
    }

    @Override
    public String getProperty(String string) {
        String string2;
        String string3 = string2 = null == this.e ? null : this.e.getProperty(string);
        if (null != string2) {
            n3.f("Property '" + string + "' overwritten by given property parameter.");
        } else {
            string2 = super.getProperty(string);
        }
        return null == string2 ? null : string2.trim();
    }

    @Override
    public String getProperty(String string, String string2) {
        return this.getProperty(new String[]{string}, string2);
    }

    public String getProperty(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            String string3 = this.getProperty(string2);
            if (string3 == null) continue;
            return string3;
        }
        return string;
    }

    @Override
    public synchronized Object put(Object object, Object object2) {
        if (!this.a.contains(object)) {
            this.a.add(String.valueOf(object));
        }
        return super.put(object, object2);
    }

    @Override
    public synchronized Enumeration keys() {
        return Collections.enumeration(this.a);
    }

    @Override
    public synchronized Object remove(Object object) {
        this.a.remove(object);
        return super.remove(object);
    }

    public byte[] getOrginalPropertiesFileContent() {
        return this.b;
    }

    public String getOriginalFilePath() {
        return this.c;
    }
}

