/*
 * Decompiled with CFR 0.152.
 */
package secauth;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import secauth.ai6;
import secauth.aqp;
import secauth.aqs;
import secauth.b9s;
import secauth.br;
import secauth.cae;
import secauth.cd;
import secauth.cm;
import secauth.cv;
import secauth.gn;
import secauth.i7;
import secauth.n0;
import secauth.n3;
import secauth.n_;
import secauth.nb;
import secauth.nd;
import secauth.ne;
import secauth.nh;
import secauth.nl;
import secauth.nm;
import secauth.nn;
import secauth.no;
import secauth.np;
import secauth.ns;
import secauth.nt;
import secauth.nv;
import secauth.nx;
import secauth.nz;

public class na {
    private static final String[] a = new String[]{"subschemaSubentry", "namingContexts", "supportedExtension", "supportedFeatures", "supportedControl", "supportedSASLMechanisms", "supportedLDAPVersion", "altServer", "defaultNamingContext", "vendorName", "vendorVersion", "ibmdirectoryversion"};
    private int b;
    private cm c;
    private Socket d;
    private Date e;
    private InputStream f;
    private OutputStream g;
    private Map<String, String> h;
    private Map<String, String> i;
    private boolean j;

    public na(cm cm2, boolean bl10, b9s b9s2) throws IOException {
        this(cm2, bl10, b9s2, null, null);
    }

    public na(@NotNull cm cm2, boolean bl10, b9s b9s2, Map<String, String> map, Map<String, String> map2) throws IOException {
        Objects.requireNonNull(cm2, "Cannot initiate an LDAP client since the URL is null.");
        this.c = cm2;
        boolean bl11 = cm2.a().equalsIgnoreCase("ldaps");
        if (!bl11 && !cm2.a().equalsIgnoreCase("ldap")) {
            throw new IOException("Unknown protocol '" + cm2.a() + "' in LDAP URL '" + cm2 + "'.");
        }
        try {
            if (bl11) {
                Objects.requireNonNull(b9s2, "Cannot initiate an LDAPS client since the TLS client context provider is null.");
                this.d = new cae(b9s2.g(), b9s2.h(), b9s2.i(), cm2.b(), cm2.c(), false, cm2.b());
            } else {
                int n10 = 20000;
                this.d = i7.a(cm2.b(), cm2.c(), true, n10);
            }
        }
        catch (Exception exception) {
            throw new IOException("Connection to LDAP server " + cm2.b() + ":" + cm2.c() + " failed: " + exception.getMessage(), exception);
        }
        this.f = this.d.getInputStream();
        this.g = this.d.getOutputStream();
        this.e = new Date();
        this.j = bl10;
        this.h = new HashMap<String, String>();
        this.h.put("memberOf", "memberOf");
        this.h.put("member", "member");
        this.h.put("userGroupCN", "cn");
        this.h.put("ou", "ou");
        this.h.put("sAMAccountName", "sAMAccountName");
        this.h.put("distinguishedName", "distinguishedName");
        this.h.put("objectSid", "objectSid");
        if (map != null) {
            map.forEach((string, string2) -> {
                if (!cd.s(string2)) {
                    this.h.put((String)string, (String)string2);
                }
            });
        }
        this.i = new HashMap<String, String>();
        this.i.put("group", "group");
        this.i.put("user", "user");
        this.i.put("person", "person");
        this.i.put("computer", "computer");
        this.i.put("organizationalUnit", "organizationalUnit");
        if (map2 != null) {
            map2.forEach((string, string2) -> {
                if (!cd.s(string2)) {
                    this.i.put((String)string, (String)string2);
                }
            });
        }
    }

    public String a() throws ai6 {
        String string = "defaultNamingContext";
        int n10 = 0;
        int n11 = 0;
        String string2 = "";
        List<n_> list = this.a(string2, a, 0, n10, n11);
        String string3 = null;
        for (n_ n_2 : list) {
            LinkedList<String> linkedList = n_2.c();
            for (String string4 : linkedList) {
                String string5 = n_2.b(string4);
                n3.f("LDAP server attribute '" + string4 + "' = '" + string5 + "'.");
                if (!string.equals(string4)) continue;
                string3 = string5;
                n3.c("This LDAP server is responsible for the domain '" + string3 + "'.");
            }
        }
        return string3;
    }

    public synchronized long a(String string, boolean bl10, boolean bl11) throws ai6, ParseException {
        n3.c("Get number of users from LDAP with base DN '" + string + "'. (personOnly=" + bl10 + ", activeOnly=" + bl11 + ")");
        ArrayList<nd> arrayList = new ArrayList<nd>();
        arrayList.add(new nh("objectClass", this.i.get("user")));
        if (bl10) {
            arrayList.add(new nh("objectClass", this.i.get("person")));
        }
        if (bl11) {
            arrayList.add(new nl(new nh("userAccountControl:1.2.840.113556.1.4.803:", "2")));
        }
        int n10 = 0;
        int n11 = 0;
        return this.a(string, 2, n10, n11, arrayList);
    }

    public synchronized List<Map<String, List<byte[]>>> a(String string, String string2, boolean bl10, boolean bl11) throws ai6, ParseException {
        return this.a(string, null, null, null, string2, bl10, bl11);
    }

    public synchronized List<Map<String, List<byte[]>>> a(String string, String string2, String string3, String string4, boolean bl10, boolean bl11) throws ai6, ParseException {
        return this.a(string, string2, null, string4, string3, bl10, bl11);
    }

    public synchronized List<Map<String, List<byte[]>>> a(String string, String string2, boolean bl10) throws ai6, ParseException {
        return this.a(string, string2, bl10, false);
    }

    public synchronized List<Map<String, List<byte[]>>> a(String string) throws ai6, ParseException {
        boolean bl10 = false;
        return this.a(string, null, null, null, null, bl10);
    }

    public synchronized List<Map<String, List<byte[]>>> a(String string, String string2, String string3, String string4) throws ai6, ParseException {
        boolean bl10 = false;
        return this.a(string, string2, string3, string4, null, bl10);
    }

    private final synchronized List<Map<String, List<byte[]>>> a(String string, String string2, String string3, String string4, String string5, boolean bl10, boolean bl11) throws ai6, ParseException {
        Object object;
        ArrayList<nd> arrayList = new ArrayList<nd>();
        arrayList.add(new nh("objectClass", this.i.get("person")));
        if (string3 != null) {
            if (!string3.toLowerCase().endsWith(string2.toLowerCase()) && (object = this.d(string2, string3)) != null) {
                string3 = ((n_)object).b("distinguishedName");
            }
            n3.f("Use organizational unit '" + string3 + " as user base DN. (former userBaseDN was '" + string + "')");
            string = string3;
        }
        if (string4 != null) {
            if (!string4.toLowerCase().endsWith(string2.toLowerCase())) {
                object = this.e(string2, string4);
                if (object != null) {
                    string4 = ((n_)object).b("distinguishedName");
                } else {
                    n3.a("userGroup " + string4 + " not found in Group Base DN " + string2);
                    return new LinkedList<Map<String, List<byte[]>>>();
                }
            }
            arrayList.add(new nh(this.h.get("memberOf"), string4));
        }
        if (!cd.s(string5)) {
            nm nm2;
            object = new ArrayList();
            if (bl11) {
                object.add(new nh(this.h.get("sAMAccountName"), string5));
                if (bl10) {
                    nm2 = this.e(string5);
                    if (null != nm2) {
                        object.add(nm2);
                    }
                    if (this.h.get("mail") != null) {
                        object.add(new nh(this.h.get("mail"), string5));
                    }
                }
            } else {
                object.add(new no(this.h.get("sAMAccountName"), string5));
                if (bl10) {
                    object.add(new no("givenName", string5));
                    object.add(new no("sn", string5));
                    object.add(new no("mail", string5));
                }
            }
            if (object.size() > 1) {
                nm2 = new nm();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    nd nd2 = (nd)iterator.next();
                    nm2.a(nd2);
                }
                arrayList.add(nm2);
            } else {
                arrayList.add((nd)object.get(0));
            }
        }
        object = null;
        int n10 = 0;
        int n11 = 30;
        boolean bl12 = false;
        LinkedList<Map<String, List<byte[]>>> linkedList = new LinkedList<Map<String, List<byte[]>>>();
        List<n_> list = this.a(string, (String[])object, 2, n10, n11, bl12, arrayList);
        for (n_ n_2 : list) {
            HashMap<String, List<byte[]>> hashMap = new HashMap<String, List<byte[]>>();
            LinkedList<String> linkedList2 = n_2.c();
            for (String string6 : linkedList2) {
                hashMap.put(string6, n_2.a(string6));
            }
            linkedList.add(hashMap);
        }
        return linkedList;
    }

    private final nm e(String string) throws ParseException {
        nm nm2 = null;
        String[] stringArray = string.split(" ");
        if (stringArray.length > 1) {
            nm2 = new nm();
            for (int i10 = 1; i10 < stringArray.length; ++i10) {
                ne ne2 = new ne();
                String string2 = "";
                String string3 = "";
                for (int i11 = 0; i11 < stringArray.length; ++i11) {
                    if (i11 < i10) {
                        string2 = string2 + " " + stringArray[i11];
                        continue;
                    }
                    string3 = string3 + " " + stringArray[i11];
                }
                string2 = string2.trim();
                string3 = string3.trim();
                ne2.a(new nh(this.h.get("givenName"), string2));
                ne2.a(new nh(this.h.get("sn"), string3));
                nm2.a(ne2);
            }
        }
        return nm2;
    }

    private final synchronized List<Map<String, List<byte[]>>> a(String string, String string2, String string3, String string4, String string5, boolean bl10) throws ai6, ParseException {
        return this.a(string, string2, string3, string4, string5, bl10, false);
    }

    private final n_ d(String string, String string2) throws ai6, ParseException {
        n3.c("Get organizational unit '" + string2 + "' from LDAP with base DN '" + string + "'.");
        ArrayList<nd> arrayList = new ArrayList<nd>();
        arrayList.add(new nh("objectClass", this.i.get("organizationalUnit")));
        arrayList.add(new nh(this.h.get("ou"), string2));
        String[] stringArray = new String[]{"*"};
        int n10 = 1;
        int n11 = 30;
        boolean bl10 = false;
        List<n_> list = this.a(string, stringArray, 2, n10, n11, bl10, arrayList);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public synchronized List<String> b(String string) throws ai6, ParseException {
        n3.c("Get organizational units from LDAP with base DN '" + string + "'.");
        List<nd> list = Collections.singletonList(new nh("objectClass", this.i.get("organizationalUnit")));
        String[] stringArray = new String[]{"*"};
        int n10 = 0;
        int n11 = 30;
        boolean bl10 = false;
        List<n_> list2 = this.a(string, stringArray, 2, n10, n11, bl10, list);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n_ n_2 : list2) {
            List<byte[]> list3 = n_2.a(this.h.get("ou"));
            if (list3 == null || list3.isEmpty()) continue;
            arrayList.add(new String(list3.get(0), StandardCharsets.UTF_8));
        }
        Collections.sort(arrayList);
        return Collections.unmodifiableList(arrayList);
    }

    public synchronized List<Map<String, List<byte[]>>> a(String string, boolean bl10) throws ai6, ParseException {
        return this.a(string, bl10, (nd)null);
    }

    public synchronized List<Map<String, List<byte[]>>> a(String string, boolean bl10, String string2) throws ai6, ParseException {
        nh nh2 = new nh(this.h.get("userGroupCN"), string2);
        return this.a(string, bl10, nh2);
    }

    public synchronized List<Map<String, List<byte[]>>> b(String string, boolean bl10, String string2) throws ai6, ParseException {
        no no2 = new no(this.h.get("userGroupCN"), string2);
        return this.a(string, bl10, no2);
    }

    public synchronized List<Map<String, List<byte[]>>> a(String string, String string2) throws ai6, ParseException {
        no no2 = new no(this.h.get("ou"), na.f(string2));
        return this.a(string, no2);
    }

    public synchronized List<Map<String, List<byte[]>>> a(String string, boolean bl10, nd nd2) throws ai6, ParseException {
        n3.c("Get usergroups from LDAP with base DN '" + string + "'.");
        ArrayList<nd> arrayList = new ArrayList<nd>();
        arrayList.add(new nh("objectClass", this.i.get("group")));
        if (nd2 != null) {
            arrayList.add(nd2);
        }
        if (bl10) {
            arrayList.add(new nl(new nh("objectClass", "builtinDomain")));
            arrayList.add(new nl(new nh("objectClass", "Builtin")));
        }
        String[] stringArray = null;
        int n10 = 0;
        int n11 = 30;
        boolean bl11 = false;
        List<n_> list = this.a(string, stringArray, 2, n10, n11, bl11, arrayList);
        LinkedList<Map<String, List<byte[]>>> linkedList = new LinkedList<Map<String, List<byte[]>>>();
        for (n_ n_2 : list) {
            HashMap<String, List<byte[]>> hashMap = new HashMap<String, List<byte[]>>();
            LinkedList<String> linkedList2 = n_2.c();
            for (String string2 : linkedList2) {
                hashMap.put(string2, n_2.a(string2));
            }
            linkedList.add(hashMap);
        }
        return linkedList;
    }

    public synchronized List<Map<String, List<byte[]>>> a(String string, nd nd2) throws ai6, ParseException {
        n3.c("Get organizational units from LDAP with base DN '" + string + "'.");
        ArrayList<nd> arrayList = new ArrayList<nd>();
        arrayList.add(new nh("objectClass", this.i.get("organizationalUnit")));
        if (nd2 != null) {
            arrayList.add(nd2);
        }
        String[] stringArray = null;
        int n10 = 0;
        int n11 = 30;
        boolean bl10 = false;
        List<n_> list = this.a(string, stringArray, 2, n10, n11, bl10, arrayList);
        LinkedList<Map<String, List<byte[]>>> linkedList = new LinkedList<Map<String, List<byte[]>>>();
        for (n_ n_2 : list) {
            HashMap<String, List<byte[]>> hashMap = new HashMap<String, List<byte[]>>();
            LinkedList<String> linkedList2 = n_2.c();
            for (String string2 : linkedList2) {
                hashMap.put(string2, n_2.a(string2));
            }
            linkedList.add(hashMap);
        }
        return linkedList;
    }

    public synchronized List<String> b(String string, boolean bl10) throws ai6, ParseException {
        return this.b(string, this.h.get("userGroupCN"), bl10);
    }

    public synchronized List<String> b(String string, String string2, boolean bl10) throws ai6, ParseException {
        n3.c("Get usergroups names from LDAP with base DN '" + string + "'. Use attribute '" + string2 + "' as usergroup name.");
        List<Map<String, List<byte[]>>> list = this.a(string, bl10);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map<String, List<byte[]>> map : list) {
            List<byte[]> list2 = map.get(string2);
            if (list2 == null || list2.isEmpty()) continue;
            arrayList.add(new String(list2.get(0), StandardCharsets.UTF_8));
        }
        return Collections.unmodifiableList(arrayList);
    }

    private final n_ e(String string, String string2) throws ai6, ParseException {
        n3.c("Get usergroup '" + string2 + "' from LDAP with base DN '" + string + "'.");
        ArrayList<nd> arrayList = new ArrayList<nd>();
        arrayList.add(new nh("objectClass", this.i.get("group")));
        arrayList.add(new nh(this.h.get("userGroupCN"), string2));
        String[] stringArray = new String[]{"*"};
        int n10 = 1;
        int n11 = 30;
        boolean bl10 = false;
        List<n_> list = this.a(string, stringArray, 2, n10, n11, bl10, arrayList);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public synchronized List<String> a(String string, String string2, String string3, boolean bl10, int n10, gn gn2) throws ai6, ParseException {
        n3.c("Get usergroups the user '" + string3 + "' is member of within user base DN '" + string + "'.");
        nh nh2 = new nh("objectClass", this.i.get("user"));
        nh nh3 = new nh(this.h.get("sAMAccountName"), string3);
        ArrayList<nd> arrayList = new ArrayList<nd>();
        arrayList.add(nh2);
        arrayList.add(nh3);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        List<String> list = this.a(string, arrayList, this.h.get("memberOf"));
        if (list != null) {
            String string4 = this.h.get("userGroupCN");
            String string5 = this.h.get("distinguishedName");
            for (String string6 : list) {
                Object object;
                if (n10 > 0) {
                    List<String> list2;
                    object = new nh("objectClass", this.i.get("group"));
                    nh nh4 = new nh(string5, na.f(string6));
                    ArrayList<nd> arrayList3 = new ArrayList<nd>();
                    arrayList3.add((nd)object);
                    arrayList3.add(nh4);
                    Map<String, List<String>> map = this.a(string2, arrayList3, new String[]{string4, this.h.get("member")});
                    if (bl10) {
                        list2 = map.get(string4);
                        if (list2 != null) {
                            arrayList2.addAll(list2);
                        }
                    } else {
                        arrayList2.add(string6);
                    }
                    if (br.b(list2 = map.get(this.h.get("member")))) continue;
                    Collection<String> collection = this.a(list2, this.i.get("group"), gn2, n10 - 1);
                    if (bl10) {
                        for (String string7 : collection) {
                            String string8 = this.c(string7);
                            if (string8 == null) continue;
                            arrayList2.add(string8);
                        }
                        continue;
                    }
                    arrayList2.addAll(collection);
                    continue;
                }
                if (bl10) {
                    object = this.c(string6);
                    if (object == null) continue;
                    arrayList2.add((String)object);
                    continue;
                }
                arrayList2.add(string6);
            }
        }
        return arrayList2;
    }

    private static String f(String string) {
        int n10;
        StringBuilder stringBuilder = new StringBuilder();
        string = string.replace("\\", "\\\\");
        for (n10 = 0; n10 < string.length(); ++n10) {
            if (string.charAt(n10) != ' ') {
                stringBuilder.append(string.substring(n10).trim());
                break;
            }
            stringBuilder.append("\\ ");
        }
        for (n10 = string.length() - 1; n10 >= 0 && string.charAt(n10) == ' '; --n10) {
            stringBuilder.append("\\ ");
        }
        String string2 = stringBuilder.toString();
        string2 = string2.replace(",", "\\,");
        string2 = string2.replace("#", "\\#");
        string2 = string2.replace("+", "\\+");
        string2 = string2.replace("<", "\\<");
        string2 = string2.replace(">", "\\>");
        string2 = string2.replace(";", "\\;");
        string2 = string2.replace("\"", "\\\"");
        string2 = string2.replace("=", "\\=");
        return string2;
    }

    public String c(String string) throws ai6, ParseException {
        String string2 = this.h.get("userGroupCN");
        String string3 = this.h.get("distinguishedName");
        n3.f("Looking up the " + string2 + " of the user group with " + string3 + " '" + string + "'");
        List<String> list = this.c(string, string3, string, string2);
        if (list.size() != 1) {
            throw new ai6("Found " + list.size() + " values of " + string2 + " for the user group with " + string3 + "  '" + string + "' instead of 1.");
        }
        String string4 = list.get(0);
        n3.f("The " + string2 + " of the user group with " + string3 + " '" + string + "' is '" + string4 + "'.");
        return string4;
    }

    public synchronized Collection<String> a(String string, String string2, boolean bl10, boolean bl11, int n10, boolean bl12, gn gn2) throws ai6, ParseException {
        Collection<Object> collection;
        n3.e("Get " + (bl12 ? "user" : "group") + " members of LDAP usergroup '" + string2 + "' with base DN '" + string + "'.");
        List<String> list = this.c(string, this.h.get(bl10 ? "userGroupCN" : "distinguishedName"), string2, this.h.get("member"));
        int n11 = list == null ? 0 : list.size();
        n3.f("The " + n11 + (bl12 ? " user" : " group") + " members of LDAP usergroup '" + string2 + "' with base DN '" + string + "' are: " + list);
        if (null != list) {
            collection = new ArrayList();
            for (String object : list) {
                String string3;
                int n12 = object.indexOf(string3 = "CN=ForeignSecurityPrincipals");
                if (n12 > 0) {
                    if (!object.startsWith("CN=")) {
                        n3.b("The foreign security principal '" + object + "' does not start with 'CN='.");
                        continue;
                    }
                    String string4 = object.substring(3, n12 - 1);
                    int n13 = string4.lastIndexOf(45);
                    if (0 > n13) {
                        n3.a("The foreign security principal SID='" + string4 + "' does not contain a '-' and thus cannot be split into domain SID and user/group SID.");
                        collection.add(object);
                        continue;
                    }
                    if (n13 >= string4.length()) {
                        n3.a("The foreign security principal SID='" + string4 + "' does not contain user/group part after the rightmost '-'.");
                        collection.add(object);
                        continue;
                    }
                    String string5 = string4.substring(0, n13);
                    n3.f("The foreign security principal SID='" + string4 + "' has to be looked up in the domain having the SID='" + string5 + "'.");
                    gn gn3 = gn2.b(string5);
                    if (null == gn3) {
                        n3.a("No LDAP connection configured to a Windows Domain Controller for the domain having SID '" + string5 + "'. Hence cannot resolve the user group member '" + object + "'.");
                        collection.add(object);
                        continue;
                    }
                    String string6 = gn3.e(string4);
                    collection.add(string6);
                    continue;
                }
                collection.add(object);
            }
            list = collection;
        }
        collection = n10 > 0 ? this.a(list, this.i.get(bl12 ? "user" : "group"), gn2, n10 - 1) : list;
        if (!bl11) {
            n3.f("Return distinguished names of user group members.");
            return collection;
        }
        n3.f("Will look up sAMAccountName for each distinguished name of user group members.");
        ArrayList arrayList = new ArrayList(collection.size());
        for (String string7 : collection) {
            List<String> list2;
            List<String> list3 = list2 = bl12 ? this.b(string, this.h.get("distinguishedName"), string7, this.h.get("sAMAccountName")) : this.c(string, this.h.get("distinguishedName"), string7, this.h.get("sAMAccountName"));
            if (br.b(list2)) {
                arrayList.add(string7);
                continue;
            }
            arrayList.add(list2.get(0));
        }
        return arrayList;
    }

    private final Collection<String> a(List<String> list, String string, gn gn2, int n10) throws ai6, ParseException {
        n3.e("Get " + string + " members of the LDAP objects '" + list + ".");
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : list) {
            gn gn3;
            n3.e("Get members of the LDAP object '" + string2 + "' in base DN '" + string2 + "'.");
            gn gn4 = gn3 = gn2 == null ? null : gn2.c(string2);
            if (null == gn3) {
                n3.f("No specific LDAP connection configured to a Windows Domain Controller for the base DN '" + string2 + "'. Will use the current LDAP connection.");
                hashSet.addAll(this.a(string2, string, gn3, n10));
                continue;
            }
            hashSet.addAll(gn3.a(string2, string, n10));
        }
        return hashSet;
    }

    public Collection<String> a(String string, String string2, gn gn2, int n10) throws ai6, ParseException {
        n3.e("Get " + string2 + " members of the LDAP object '" + string + ".");
        String string3 = this.i.get("group");
        HashSet<String> hashSet = new HashSet<String>();
        n3.e("Get members of the LDAP object '" + string + "' in base DN '" + string + "'.");
        nh nh2 = new nh(this.h.get("distinguishedName"), string);
        List<nd> list = Collections.singletonList(nh2);
        Map<String, List<String>> map = this.a(string, list, new String[]{this.h.get("member"), "objectClass"});
        List<String> list2 = Collections.unmodifiableList(map.get(this.h.get("member")));
        Set<String> set = br.b(map.get("objectClass"));
        n3.f("The " + string2 + " members of LDAP object '" + string + "' in base DN '" + string + "' are: " + list2);
        n3.f("The LDAP objectClass of the group member '" + string + "' is: " + set + ".");
        if (!br.b(set)) {
            if (string2 == null || string2.equals("*") || set.contains(string2)) {
                hashSet.add(string);
            }
            if (set.contains(string3)) {
                List<String> list3;
                Collection<String> collection = list3 = n10 < 1 ? list2 : this.a(list2, string2, gn2, n10 - 1);
                if (!br.b(list3)) {
                    hashSet.addAll(list3);
                }
            }
        }
        return hashSet;
    }

    public synchronized List<String> c(String string, boolean bl10) throws ai6, ParseException {
        n3.c("Get user attribute types from LDAP with base DN '" + string + "'. (excludeSystemAttributes=" + bl10 + ")");
        List<nd> list = Collections.singletonList(new nh("objectClass", this.i.get("user")));
        String[] stringArray = new String[]{"subschemaSubentry"};
        int n10 = 1;
        int n11 = 30;
        boolean bl11 = false;
        List<n_> list2 = this.a(string, stringArray, 2, n10, n11, bl11, list);
        if (!list2.isEmpty()) {
            n_ n_2 = list2.get(0);
            List<byte[]> list3 = n_2.a("subschemaSubentry");
            String string2 = new String(list3.get(0), StandardCharsets.UTF_8);
            n3.c("Query schema '" + string2 + "' for (user) attributetypes.");
            List<nd> list4 = Collections.singletonList(new nh("objectClass", "subSchema"));
            String[] stringArray2 = new String[]{"attributetypes"};
            n10 = 0;
            list2 = this.a(string2, stringArray2, 2, n10, n11, bl11, list4);
            if (!list2.isEmpty()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                n_ n_3 = list2.get(0);
                List<byte[]> list5 = n_3.a("attributeTypes");
                for (byte[] object : list5) {
                    String string3 = new String(object, StandardCharsets.UTF_8);
                    n3.f("Found attribute name: " + string3);
                    String[] stringArray3 = string3.split("'");
                    arrayList.add(stringArray3[1]);
                }
                if (bl10) {
                    Iterator<Object> iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        String string4 = (String)iterator.next();
                        if (!string4.startsWith("aCS") && !string4.startsWith("dns") && !string4.startsWith("dNS") && !string4.startsWith("domain") && !string4.startsWith("dhcp") && !string4.startsWith("cOM") && !string4.startsWith("dSUI") && !string4.startsWith("fRS") && !string4.startsWith("fSMO") && !string4.startsWith("gPC") && !string4.startsWith("ipsec") && !string4.startsWith("lDAP") && !string4.startsWith("lSA") && !string4.startsWith("meeting") && !string4.startsWith("MSMQ-") && !string4.startsWith("mS-DS-") && !string4.startsWith("ms-DS-") && !string4.startsWith("mS-SQL") && !string4.startsWith("ms-net-") && !string4.startsWith("mSMQ") && !string4.startsWith("msAuthz-") && !string4.startsWith("msCOM-") && !string4.startsWith("msDFS-") && !string4.startsWith("msDFSR-") && !string4.startsWith("msDRM-") && !string4.startsWith("msDNS-") && !string4.startsWith("msDS-") && !string4.startsWith("msDs-") && !string4.startsWith("msExch") && !string4.startsWith("msFRS-") && !string4.startsWith("msFVE-") && !string4.startsWith("msIIS-") && !string4.startsWith("msImaging-") && !string4.startsWith("msKds-") && !string4.startsWith("msPKI") && !string4.startsWith("msNP") && !string4.startsWith("msRADIUS") && !string4.startsWith("msRAS") && !string4.startsWith("msRRAS") && !string4.startsWith("msds-") && !string4.startsWith("msi") && !string4.startsWith("msSFU") && !string4.startsWith("msSPP-") && !string4.startsWith("msTAPI-") && !string4.startsWith("msTPM") && !string4.startsWith("msTS") && !string4.startsWith("msWMI-") && !string4.startsWith("netboot") && !string4.startsWith("nT") && !string4.startsWith("print") && !string4.startsWith("pKI") && !string4.startsWith("pKT") && !string4.startsWith("rID") && !string4.startsWith("rpc")) continue;
                        n3.f("Removed attribute '" + string4 + "' as an assumed system attribute.");
                        iterator.remove();
                    }
                }
                arrayList.sort(null);
                return Collections.unmodifiableList(arrayList);
            }
        }
        return Collections.emptyList();
    }

    public synchronized List<String> b(String string, String string2, String string3, String string4) throws ai6, ParseException {
        nh nh2 = new nh("objectClass", this.i.get("user"));
        nh nh3 = new nh(string2, string3);
        ArrayList<nd> arrayList = new ArrayList<nd>();
        arrayList.add(nh2);
        arrayList.add(nh3);
        return this.a(string, arrayList, string4);
    }

    public synchronized String b(String string, String string2) throws ai6, ParseException {
        List<nd> list = Collections.singletonList(new nh(this.h.get("objectSid"), string2));
        List<String> list2 = this.a(string, list, this.h.get("distinguishedName"));
        if (null == list2) {
            return null;
        }
        if (list2.size() == 1) {
            return list2.get(0);
        }
        throw new ai6("Found " + list2.size() + " DNs for the objectSid '" + string2 + "'.");
    }

    public synchronized String d(String string) throws ai6, ParseException {
        nh nh2 = new nh(this.h.get("distinguishedName"), string);
        List<nd> list = Collections.singletonList(nh2);
        List<String> list2 = this.a(string, list, this.h.get("objectSid"));
        if (null == list2) {
            return null;
        }
        if (list2.size() == 1) {
            return list2.get(0);
        }
        throw new ai6("Found " + list2.size() + " objectSids for the DN '" + string + "'.");
    }

    public synchronized List<String> c(String string, String string2, String string3, String string4) throws ai6, ParseException {
        nh nh2 = new nh("objectClass", this.i.get("group"));
        nh nh3 = new nh(string2, string3);
        ArrayList<nd> arrayList = new ArrayList<nd>();
        arrayList.add(nh2);
        arrayList.add(nh3);
        return this.a(string, arrayList, string4);
    }

    private final List<String> a(String string, List<nd> list, String string2) throws ai6 {
        Map<String, List<String>> map = this.a(string, list, new String[]{string2});
        return Collections.unmodifiableList(map.get(string2));
    }

    private final Map<String, List<String>> a(String string, List<nd> list, String[] stringArray) throws ai6 {
        int n10 = 0;
        int n11 = 0;
        List<n_> list2 = this.a(string, stringArray, 2, n10, n11, list);
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (String string2 : stringArray) {
            hashMap.put(string2, new ArrayList());
        }
        this.a(list2, hashMap, string, list, stringArray);
        return hashMap;
    }

    private final void a(List<n_> list, Map<String, List<String>> map, String string, List<nd> list2, String[] stringArray) throws ai6 {
        for (n_ n_2 : list) {
            for (String string2 : stringArray) {
                Object object;
                List<byte[]> list3 = n_2.a(string2);
                String string3 = null;
                if ((list3 == null || list3.isEmpty()) && null != (object = n_2.c(string2))) {
                    n3.f("The LDAP search for the attribute '" + string2 + "' has returned the result range '" + (String)object + "'.");
                    list3 = n_2.a(string2 + ";range=" + (String)object);
                    int n10 = ((String)object).indexOf(45);
                    if (0 > n10) {
                        throw new ai6("The LDAP search for the attribute '" + string2 + "' has returned the result range '" + (String)object + "'. There is no '-' in the range.");
                    }
                    Object object2 = ((String)object).substring(n10 + 1);
                    if (!"*".equals(object2)) {
                        int n11;
                        try {
                            n11 = Integer.parseInt((String)object2);
                        }
                        catch (Exception exception) {
                            throw new ai6("The LDAP search for the attribute '" + string2 + "' has returned the result range '" + (String)object + "'. The end of the range is no integer: " + exception.getMessage(), exception);
                        }
                        string3 = n11 + 1 + "-*";
                    }
                }
                if (list3 == null) continue;
                object = map.get(string2);
                for (Object object2 : list3) {
                    object.add(this.a(string2, (byte[])object2, n_2.b()));
                }
                if (string3 == null) continue;
                n3.f("Searching for the next range '" + string3 + "' of attribute '" + string2 + "' values.");
                int n12 = 0;
                int n13 = 0;
                List<n_> list4 = this.a(string, new String[]{string2 + ";range=" + string3}, 2, n12, n13, list2);
                this.a(list4, map, string, list2, stringArray);
            }
        }
    }

    public synchronized List<n_> a(String string, String[] stringArray, int n10, int n11, int n12) throws ai6 {
        nn nn2 = new nn("objectclass");
        List<nd> list = Collections.singletonList(nn2);
        boolean bl10 = false;
        return this.a(string, stringArray, n10, n11, n12, bl10, list);
    }

    public synchronized List<n_> a(String string, String[] stringArray, int n10, int n11, int n12, List<nd> list) throws ai6 {
        boolean bl10 = false;
        return this.a(string, stringArray, n10, n11, n12, bl10, list);
    }

    private final List<n_> a(String string, String[] stringArray, int n10, int n11, int n12, boolean bl10, @NotNull List<nd> list) throws ai6 {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        Objects.requireNonNull(list, "No LDAP filter specified.");
        if (list.isEmpty()) {
            throw new ai6("Specified LDAP filter list is empty.");
        }
        nd nd2 = nd.a(list);
        n3.f("LDAP searching using filter '" + nd2.toString() + "'.");
        ns ns2 = new ns(++this.b);
        if (stringArray != null) {
            n3.f("LDAP searching for attribute '" + Arrays.toString(stringArray) + "' in base DN '" + string + "'.");
            ns2.a(Arrays.asList(stringArray));
        } else {
            n3.f("LDAP searching for all attributes of an entry in base DN '" + string + "'.");
        }
        ns2.a(string);
        ns2.b(3);
        ns2.a(nd2);
        ns2.a(n10);
        ns2.c(n11);
        ns2.d(n12);
        ns2.a(bl10);
        try {
            ns2.a(this.g);
        }
        catch (Exception exception) {
            throw new ai6("Error sending the search to the LDAP server: " + exception, exception);
        }
        LinkedList<n_> linkedList = new LinkedList<n_>();
        boolean bl11 = false;
        while (!bl11) {
            nb nb2;
            nb nb3;
            try {
                nb3 = nb.b(this.f);
            }
            catch (Exception exception) {
                throw new ai6("Response from LDAP server cannot be parsed: " + exception, exception);
            }
            if (nb3 instanceof n_) {
                linkedList.add((n_)nb3);
                continue;
            }
            if (nb3 instanceof nx) {
                nb2 = (nx)nb3;
                throw new ai6("Received error message during search from LDAP server. Result code is " + ((nv)nb2).b() + ", name of response is '" + ((nx)nb2).d() + "' with message: " + ((nv)nb2).c());
            }
            if (nb3 instanceof nz) {
                nb2 = (nz)nb3;
                n3.f("LDAP search finished with result code " + ((nv)nb2).b() + " (number of results: " + linkedList.size() + ")");
                if (((nv)nb2).c() != null) {
                    n3.f(((nv)nb2).c());
                }
                bl11 = true;
                continue;
            }
            if (nb3 instanceof n0) {
                nb2 = (n0)nb3;
                n3.g("Ignored the LDAP search result reference to " + Arrays.asList(((n0)nb2).b()));
                continue;
            }
            n3.b("Ignored LDAP response message type " + nb3);
        }
        return Collections.unmodifiableList(linkedList);
    }

    private final long a(String string, int n10, int n11, int n12, List<nd> list) throws ai6 {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        Objects.requireNonNull(list, "No LDAP filter specified.");
        if (list.isEmpty()) {
            throw new ai6("Specified LDAP filter list is empty.");
        }
        nd nd2 = nd.a(list);
        n3.f("LDAP counting using filter '" + nd2.toString() + "'.");
        ns ns2 = new ns(++this.b);
        ns2.a(string);
        ns2.b(3);
        ns2.a(nd2);
        ns2.a(n10);
        ns2.c(n11);
        ns2.d(n12);
        ns2.a(true);
        try {
            ns2.a(this.g);
        }
        catch (Exception exception) {
            throw new ai6("Error sending the search to the LDAP server: " + exception, exception);
        }
        long l10 = 0L;
        boolean bl10 = false;
        while (!bl10) {
            int n13;
            try {
                n13 = nb.a(this.f);
            }
            catch (Exception exception) {
                throw new ai6("Response from LDAP server cannot be parsed: " + exception, exception);
            }
            switch (n13) {
                case 4: {
                    ++l10;
                    break;
                }
                case 24: {
                    ++l10;
                    bl10 = true;
                    break;
                }
                case 5: {
                    bl10 = true;
                }
            }
        }
        return l10;
    }

    public String a(String string, byte[] byArray, String string2) throws ai6 {
        boolean bl10 = "objectGUID".equalsIgnoreCase(string);
        boolean bl11 = "objectSid".equalsIgnoreCase(string);
        if (this.j && bl10) {
            try {
                return aqp.a(byArray);
            }
            catch (ParseException parseException) {
                throw new ai6("The objectGUID value of the attribute '" + string + "' for LDAP object in DN '" + string2 + "' could not be interpreted as a GUID:" + parseException.getMessage(), parseException);
            }
        }
        if (this.j && bl11) {
            try {
                return aqs.a(byArray);
            }
            catch (ParseException parseException) {
                throw new ai6("The objectSid value of the attribute '" + string + "' for LDAP object in DN '" + string2 + "' could not be interpreted as a SID:" + parseException.getMessage(), parseException);
            }
        }
        boolean bl12 = bl10 || bl11;
        return bl12 ? cv.a(byArray) : new String(byArray, StandardCharsets.UTF_8);
    }

    public synchronized void c(String string, String string2) throws ai6 {
        np.a(string, string2, this.f, this.g, ++this.b);
    }

    public synchronized void b() {
        if (this.g == null || this.d == null) {
            return;
        }
        if (this.d.isClosed() || this.d.isOutputShutdown()) {
            this.e();
            return;
        }
        try {
            nt nt2 = new nt(++this.b);
            nt2.a(this.g);
        }
        catch (Exception exception) {
            n3.a("Error unbinding from LDAP server: " + exception);
        }
        finally {
            try {
                this.d.close();
            }
            catch (IOException iOException) {
                n3.a("Error closing the socket to the LDAP server: " + iOException);
            }
            this.e();
        }
    }

    private final void e() {
        this.f = null;
        this.g = null;
        this.d = null;
    }

    public boolean c() {
        if (this.d != null) {
            return !this.d.isClosed();
        }
        return false;
    }

    public void d() {
        this.e = new Date();
    }

    public String toString() {
        return "LDAP server at " + this.c.toString();
    }
}

