/*
 * Decompiled with CFR 0.152.
 */
package secauth;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import secauth.b9x;
import secauth.b9z;
import secauth.d4;
import secauth.db;
import secauth.ds;
import secauth.dy;
import secauth.dz;
import secauth.e1;
import secauth.e7;
import secauth.ed;
import secauth.eu;
import secauth.ew;

class caa
extends b9z {
    private ds a;
    private ds b;
    private byte[] c;
    private int d;
    private byte[] e;
    private int f;
    private boolean g;

    public caa(byte[] byArray, boolean bl10) throws b9x {
        db db2;
        this.g = bl10;
        if (byArray[0] != 3) {
            throw new b9x("Received TLS server key exchange message contains the unsupported ECDH curve type " + byArray[0] + ". Only named_curve is supported.");
        }
        this.d = (byArray[1] & 0xFF) << 8 | byArray[2] & 0xFF;
        if (this.d != 23 && this.d != 24 && this.d != 29 && this.d != 30) {
            throw new b9x("Received TLS server key exchange message contains the unsupported ECDH named curve " + this.d + ". Only secp256r1, secp384r1, X25519 and X448 are supported.");
        }
        int n10 = byArray[3] & 0xFF;
        byte[] byArray2 = new byte[n10];
        System.arraycopy(byArray, 4, byArray2, 0, n10);
        if (this.d == 23) {
            try {
                db2 = new dy();
                this.a = new ds(db2, byArray2);
            }
            catch (Exception exception) {
                throw new b9x("Received TLS server key exchange message contains secp256r1 ECDH parameters which cannot be parsed: " + exception.getMessage(), exception);
            }
        } else if (this.d == 24) {
            try {
                db2 = new dz();
                this.b = new ds(db2, byArray2);
            }
            catch (Exception exception) {
                throw new b9x("Received TLS server key exchange message contains secp384r1 ECDH parameters which cannot be parsed: " + exception.getMessage(), exception);
            }
        } else {
            this.c = byArray2;
        }
        int n11 = 4 + n10;
        if (bl10) {
            this.f = (byArray[n11] & 0xFF) << 8 | byArray[n11 + 1] & 0xFF;
            n11 += 2;
        } else {
            this.f = -1;
        }
        int n12 = (byArray[n11] & 0xFF) << 8 | byArray[n11 + 1] & 0xFF;
        if (n12 > 8196) {
            throw new b9x("encoded ECDH signature too long");
        }
        this.e = new byte[n12];
        System.arraycopy(byArray, n11 + 2, this.e, 0, n12);
    }

    public caa(ds ds2, ds ds3, int n10, boolean bl10, int n11) {
        this.a = ds2;
        this.b = ds3;
        this.d = n10;
        this.f = n11;
        this.g = bl10;
    }

    public int a() {
        return this.f;
    }

    public byte[] b() throws IOException {
        byte[] byArray = this.d == 23 && null != this.a ? this.a.e() : (this.d == 24 && null != this.b ? this.b.e() : this.c);
        byte[] byArray2 = new byte[4 + byArray.length];
        byArray2[0] = 3;
        byArray2[1] = (byte)(this.d >> 8 & 0xFF);
        byArray2[2] = (byte)(this.d & 0xFF);
        byArray2[3] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray2, 4, byArray.length);
        return byArray2;
    }

    public byte[] a(byte[] byArray, byte[] byArray2) throws IOException, b9x {
        if (this.g) {
            d4 d42 = this.c();
            d42.a(byArray);
            d42.a(byArray2);
            d42.a(this.b());
            return d42.m();
        }
        ed ed2 = new ed();
        ed2.a(byArray);
        ed2.a(byArray2);
        ed2.a(this.b());
        e7 e72 = new e7();
        e72.a(byArray);
        e72.a(byArray2);
        e72.a(this.b());
        byte[] byArray3 = ed2.m();
        byte[] byArray4 = e72.m();
        byte[] byArray5 = new byte[36];
        System.arraycopy(byArray3, 0, byArray5, 0, 16);
        System.arraycopy(byArray4, 0, byArray5, 16, 20);
        return byArray5;
    }

    public d4 c() throws b9x {
        switch (this.f) {
            case 513: 
            case 515: {
                return new e7();
            }
            case 1025: 
            case 1027: 
            case 2052: 
            case 2057: {
                return new eu();
            }
            case 1281: 
            case 1283: 
            case 2053: 
            case 2058: {
                return new ew();
            }
            case 1537: 
            case 1539: 
            case 2054: 
            case 2059: {
                return new e1();
            }
        }
        throw new b9x("Server key exchange contains the unsupported hash algorithm ID " + Integer.toHexString(this.f));
    }

    public boolean d() throws b9x {
        switch (this.f) {
            case 513: 
            case 515: 
            case 1025: 
            case 1027: 
            case 1281: 
            case 1283: 
            case 1537: 
            case 1539: {
                return false;
            }
            case 2052: 
            case 2053: 
            case 2054: 
            case 2057: 
            case 2058: 
            case 2059: {
                return true;
            }
        }
        throw new b9x("Server key exchange contains the unsupported hash algorithm ID " + Integer.toHexString(this.f) + " to determine if PSS was used.");
    }

    public void a(OutputStream outputStream, byte[] byArray) throws IOException {
        this.e = byArray;
        outputStream.write(12);
        Objects.requireNonNull(this.e, "signature in TLS server key exchange is null.");
        int n10 = this.e.length;
        byte[] byArray2 = this.b();
        int n11 = byArray2.length + n10 + 2 + (this.g ? 2 : 0);
        outputStream.write(n11 >> 16 & 0xFF);
        outputStream.write(n11 >> 8 & 0xFF);
        outputStream.write(n11 & 0xFF);
        outputStream.write(byArray2);
        if (this.g) {
            outputStream.write(this.f >> 8 & 0xFF);
            outputStream.write(this.f & 0xFF);
        }
        outputStream.write(n10 >> 8 & 0xFF);
        outputStream.write(n10 & 0xFF);
        outputStream.write(this.e);
    }

    public byte[] e() {
        return this.e;
    }

    public ds f() {
        return this.a;
    }

    public ds g() {
        return this.b;
    }

    public byte[] h() {
        return this.c;
    }
}

