/*
 * Decompiled with CFR 0.152.
 */
package secauth;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import secauth.aqm;
import secauth.b11;
import secauth.b1_;
import secauth.b1x;
import secauth.b1z;
import secauth.b_c;
import secauth.br;
import secauth.bwo;
import secauth.bxv;
import secauth.bxx;
import secauth.byn;
import secauth.cam;
import secauth.cbl;
import secauth.k;
import secauth.n3;
import secauth.xb;
import seccommerce.mobile.bo.CntReqStatusType;
import seccommerce.mobile.bo.ContactRequest;
import seccommerce.user.bo.IdProfile;
import seccommerce.user.bo.VisibilityType;

@b1z(a=b1_.IDSERVER, b=b11.REQUEST)
public class bxw
implements bxv {
    @b1x
    private bwo a;
    @b1x
    private byn b;

    @Override
    public void a(@NotNull List<Long> list) throws aqm {
        Objects.requireNonNull(list, "acceptContactRequest: contactRequestIds must not be null");
        try {
            this.b.b(list);
        }
        catch (b_c b_c2) {
            throw new aqm("ContactRequestService: Could not accept contact request " + br.a(list, ","), b_c2);
        }
    }

    @Override
    public void b(@NotNull List<Long> list) throws aqm {
        Objects.requireNonNull(list, "rejectContactRequest: contactRequestIds must not be null");
        try {
            this.b.c(list);
        }
        catch (b_c b_c2) {
            throw new aqm("ContactRequestService: Could not reject contact request " + br.a(list, ","), b_c2);
        }
    }

    public void a(@NotNull Long l10, @NotNull Long l11, @NotNull IdProfile idProfile) throws aqm {
        Objects.requireNonNull(l10, "sendContactRequest: orgId must not be null");
        Objects.requireNonNull(l11, "Cannot sendContactRequest: requesterUserIdId is null");
        Objects.requireNonNull(idProfile, "Cannot sendContactRequest: recipient is null");
        if (VisibilityType.PRIVATE.equals(idProfile.getPrfVisibility())) {
            this.b(l10, l11, idProfile.getUserIdId());
            return;
        }
        this.a(l10, l11, idProfile.getUserIdId());
    }

    @Override
    public void a(@NotNull Long l10, @NotNull Long l11, @NotNull Long l12) throws aqm {
        Objects.requireNonNull(l10, "sendContactRequest: orgId must not be null");
        Objects.requireNonNull(l11, "Cannot sendContactRequest: requesterUserIdId is null");
        Objects.requireNonNull(l12, "Cannot sendContactRequest: recipientUserIdId is null");
        this.a(l10, l11, l12, bxx.a);
    }

    public void b(@NotNull Long l10, @NotNull Long l11, @NotNull Long l12) throws aqm {
        Objects.requireNonNull(l10, "sendHiddenContactRequest: orgId must not be null");
        Objects.requireNonNull(l11, "Cannot sendHiddenContactRequest: requesterUserIdId is null");
        Objects.requireNonNull(l12, "Cannot sendHiddenContactRequest: recipientUserIdId is null");
        this.a(l10, l11, l12, bxx.b);
    }

    @NotNull
    public List<cam> a(@NotNull Set<Long> set) throws aqm {
        List list;
        Objects.requireNonNull(set, "get: contactRequestIds must not be null");
        try {
            list = this.b.a(set);
        }
        catch (b_c b_c2) {
            throw new aqm("Error while trying to get contact request with id " + set, b_c2);
        }
        if (list == null) {
            return Collections.emptyList();
        }
        return cbl.a(list, cam::new);
    }

    private final void a(@NotNull Long l10, @NotNull Long l11, @NotNull Long l12, @NotNull bxx bxx2) throws aqm {
        Objects.requireNonNull(l10, "send: orgId must not be null");
        Objects.requireNonNull(l11, "Cannot send contact request: requesterUserIdId is null");
        Objects.requireNonNull(l12, "Cannot send contact request: recipientUserIdId is null");
        Objects.requireNonNull(bxx2, "Cannot send contact request: visibility is null");
        if (l11.equals(l12)) {
            throw new IllegalArgumentException("ContactRequestService Cannot create new contact request: userIdId " + l12 + " cannot be both requester and recipient");
        }
        if (this.b(l11, l12) != null) {
            n3.f("ContactRequestService: Not sending a contact request from " + l11 + " to " + l12 + " because a request was already sent earlier.");
            return;
        }
        n3.f("Sending contact request from userIdId " + l11 + " to userIdId " + l12);
        try {
            this.b.a(l10, l11, l12, CntReqStatusType.ah, bxx2);
        }
        catch (b_c b_c2) {
            throw new aqm("Error while sending contact request from userIdId " + l11 + " to userIdId " + l12, b_c2);
        }
        n3.g("Sending notification to user " + l12 + " about received contact request");
        this.a.a(new xb(l12, l10));
    }

    @Nullable
    public cam b(@NotNull Long l10, @NotNull Long l11) throws aqm {
        Objects.requireNonNull(l10, "Cannot findRequest: userIdIdA is null");
        Objects.requireNonNull(l11, "Cannot findRequest: userIdIdB is null");
        n3.f("ContactRequestService: Searching if a contact request exists between " + l10 + " and " + l11);
        try {
            List<ContactRequest> list = this.b.a(l10, l11);
            if (list.isEmpty()) {
                n3.f("ContactRequestService: Found no contact request between " + l10 + " and " + l11);
                return null;
            }
            if (list.size() > 1) {
                throw new aqm("Found " + list.size() + " ContactRequests from userIdId " + l10 + " to " + l11 + " in the database. Expected at most one");
            }
            n3.f("ContactRequestService: Found contact request between " + l10 + " and " + l11 + ": " + list.get(0));
            return cbl.a((k)list.get(0), new cam());
        }
        catch (b_c b_c2) {
            throw new aqm("Error while finding contact requests between userIdId " + l10 + " and userIdId " + l11, b_c2);
        }
    }

    @Override
    @NotNull
    public List<cam> a(@NotNull Long l10) throws aqm {
        Objects.requireNonNull(l10, "getAllRequests: userIdId must not be null");
        n3.f("ContactRequestService: Getting all contact requests userIdId " + l10 + " is part of");
        try {
            return cbl.a(this.b.d(l10), cam::new);
        }
        catch (b_c b_c2) {
            throw new aqm("ContactRequestService: Error while getting all contact requests of userIdId " + l10, b_c2);
        }
    }

    @Override
    @NotNull
    public List<cam> b(@NotNull Long l10) throws aqm {
        Objects.requireNonNull(l10, "Cannot getAllAcceptedRequests: userIdId is null");
        n3.f("ContactRequestService: Getting all accepted contact requests where userIdId " + l10 + " is a part of");
        try {
            return this.b.e(l10).stream().map(contactRequest -> cbl.a(contactRequest, new cam())).collect(Collectors.toList());
        }
        catch (b_c b_c2) {
            throw new aqm("Error while querying getAllAccepted", b_c2);
        }
    }

    @Override
    @NotNull
    public List<cam> c(@NotNull Long l10) throws aqm {
        Objects.requireNonNull(l10, "getAllPendingRequestsForRecipient: userIdId must not be null");
        n3.f("ContactRequestService: Getting all pending contact requests where userIdId " + l10 + " is recipient");
        try {
            return this.b.g(l10).stream().map(contactRequest -> cbl.a(contactRequest, new cam())).collect(Collectors.toList());
        }
        catch (b_c b_c2) {
            throw new aqm("Error while querying getAllPendingRequests", b_c2);
        }
    }

    @Override
    @NotNull
    public List<cam> d(@NotNull Long l10) throws aqm {
        Objects.requireNonNull(l10, "getAllRejectedRequestsForRecipient: userIdId must not be null");
        n3.f("ContactRequestService: Getting all rejected contact requests where userIdId " + l10 + " is recipient");
        try {
            return this.b.h(l10).stream().map(contactRequest -> cbl.a(contactRequest, new cam())).collect(Collectors.toList());
        }
        catch (b_c b_c2) {
            throw new aqm("Error while querying getAllPendingRequests", b_c2);
        }
    }

    @Override
    public void a(@NotNull Long l10, @NotNull Long l11) throws aqm {
        Objects.requireNonNull(l10, "deleteContactRequest: userIdIdA must not be null");
        Objects.requireNonNull(l11, "deleteContactRequest: userIdIdB must not be null");
        cam cam2 = this.b(l10, l11);
        if (cam2 == null) {
            throw new aqm("ContactRequestService: Cannot delete contact request: No request found between userIdId " + l10 + " and " + l11);
        }
        n3.f("ContactRequestService: Deleting contact request " + cam2.a());
        try {
            this.b.f(cam2.a());
        }
        catch (b_c b_c2) {
            throw new aqm("ContactRequestService: Cannot delete contact request " + cam2.a(), b_c2);
        }
    }

    @Override
    public long e(@NotNull Long l10) throws aqm {
        Objects.requireNonNull(l10, "deleteAllContactRequestsOfUserIdId: userIdId must not be null");
        n3.f("ContactRequestService: Deleting all contact requests where userIdId " + l10 + " is either requester or recipient");
        try {
            return this.b.c(l10);
        }
        catch (b_c b_c2) {
            throw new aqm("ContactRequestService: Cannot delete all contact requests of userIdId " + l10, b_c2);
        }
    }
}

