/*
 * Decompiled with CFR 0.152.
 */
package secauth;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import secauth.ai6;
import secauth.akh;
import secauth.al_;
import secauth.anm;
import secauth.b11;
import secauth.b1_;
import secauth.b1x;
import secauth.b1z;
import secauth.bh9;
import secauth.bxc;
import secauth.bxl;
import secauth.ceb;
import secauth.cej;
import secauth.cf2;
import secauth.gt;
import secauth.l;
import secauth.n3;
import secauth.r;
import seccommerce.user.bo.UserGroup;
import seccommerce.user.bo.UserRole;
import seccommerce.workflow.bo.UserGroupIpRange;

@b1z(a=b1_.IDSERVER, b=b11.REQUEST)
public class bxm
implements bxl {
    @b1x
    private Connection a;

    @Override
    public UserGroup a(@NotNull Long l10, @NotNull Long l11) throws SQLException, ai6 {
        Objects.requireNonNull(l10, "Cannot get usergroup by id. User group id is null.");
        Objects.requireNonNull(l11, "Cannot get usergroup by id. OrgId is null.");
        return anm.a().b(this.getClass(), Long.class, UserGroup.class).a(l10, () -> {
            try {
                return al_.a(ceb.class).b(l10, l11, this.a);
            }
            catch (SQLException | ai6 exception) {
                throw new RuntimeException("Cannot get user group by id: " + exception.getMessage(), exception);
            }
        });
    }

    @Override
    public UserGroup a(@NotNull String string, @NotNull Long l10) throws SQLException, ai6 {
        Objects.requireNonNull(string, "Cannot get usergroup. User group name is null.");
        Objects.requireNonNull(l10, "Cannot get usergroup. OrgId is null.");
        return anm.a().b(this.getClass(), String.class, UserGroup.class).a(string, () -> {
            try {
                return al_.a(ceb.class).b(string, l10, this.a);
            }
            catch (SQLException | ai6 exception) {
                throw new RuntimeException("Cannot get user group by id: " + exception.getMessage(), exception);
            }
        });
    }

    @Override
    @NotNull
    public Set<Long> b(@NotNull Long l10, @NotNull Long l11) throws SQLException {
        List<UserRole> list = al_.a(cej.class).a(l10, l11, this.a);
        return list.stream().map(UserRole::getUserIdId).collect(Collectors.toSet());
    }

    @Override
    public boolean a(@NotNull Long l10, @NotNull String string, @NotNull Long l11, @Nullable bh9 bh92, @Nullable InetAddress inetAddress) throws SQLException, ai6 {
        Objects.requireNonNull(l10, "Cannot check if user is member of a usergroup. UserId is null.");
        Objects.requireNonNull(string, "Cannot check if user is member of a usergroup. User group name is null.");
        Objects.requireNonNull(l11, "Cannot check if user is member of a usergroup. OrgId is null.");
        UserGroup userGroup = al_.a(ceb.class).b(string, l11, this.a);
        if (userGroup == null) {
            n3.f("No default user group with name " + string + " found.");
            return false;
        }
        gt gt2 = gt.a(bh92, l11).a();
        List<UserGroupIpRange> list = al_.a(cf2.class).i(new UserGroupIpRange(), this.a);
        return gt2.a(l10, userGroup, inetAddress, list, this.a, false);
    }

    @Override
    @Nullable
    public Long a(String string, boolean bl10, @NotNull Long l10) throws SQLException, ai6 {
        UserGroup userGroup = null;
        try {
            userGroup = this.a(string, l10);
        }
        catch (Exception exception) {
            n3.a(exception);
        }
        if (userGroup != null) {
            return userGroup.getId();
        }
        if (bl10) {
            String string2 = string.toLowerCase();
            UserGroup userGroup2 = new UserGroup();
            try {
                userGroup2.addWhereFunctionPattern("name", 23);
            }
            catch (r r10) {
                throw new ai6("Cannot set QBE pattern 'func lower' for user groups", r10);
            }
            userGroup2.setName(string2);
            userGroup2.setOrgId(l10);
            List<UserGroup> list = al_.a(ceb.class).i(userGroup2, this.a);
            if (!list.isEmpty()) {
                n3.f("Found " + list.size() + " usergroups with lower case name '" + string2 + "'");
                return list.get(0).getId();
            }
        }
        return null;
    }

    @Override
    @NotNull
    public List<Long> a(@NotNull List<String> list, @NotNull Long l10) throws SQLException, ai6 {
        Objects.requireNonNull(list, "Cannot get usergroup ids for names because the list is null");
        Objects.requireNonNull(l10, "Cannot get usergroup ids for names because the orgId is null");
        ceb ceb2 = al_.a(ceb.class);
        LinkedList<Long> linkedList = new LinkedList<Long>();
        for (String string : list) {
            linkedList.add(ceb2.b(string, l10, this.a).getId());
        }
        return linkedList;
    }

    @Override
    public void a(@NotNull Long l10, @NotNull List<Long> list, @NotNull Long l11) throws SQLException, ai6, l {
        Objects.requireNonNull(l10, "Can't add user to groups. UserId is null.");
        Objects.requireNonNull(list, "Can't add user to groups. User group ids are null.");
        Objects.requireNonNull(l11, "Can't add user to groups. OrgId is null.");
        cej cej2 = al_.a(cej.class);
        for (Long l12 : list) {
            UserRole userRole = new UserRole();
            userRole.setUserIdId(l10);
            userRole.setUserGroupId(l12);
            if (cej2.h(userRole, this.a) != 0L) continue;
            cej2.a(userRole, this.a);
            String string = "Inserted userId " + l10 + " into userGroup " + l12;
            akh.ac().a(this.a, l11, 2000, string, l10, "userid", 0L, null);
        }
        bxc.a(l11);
    }

    @Override
    public void b(@NotNull Long l10, @NotNull List<Long> list, @NotNull Long l11) throws SQLException, ai6 {
        Objects.requireNonNull(l10, "Can't remove user from groups. UserId is null.");
        Objects.requireNonNull(list, "Can't remove user from groups. User group ids are null.");
        Objects.requireNonNull(l11, "Can't remove user from groups. OrgId is null.");
        cej cej2 = al_.a(cej.class);
        for (Long l12 : list) {
            UserRole userRole = new UserRole();
            userRole.setUserIdId(l10);
            userRole.setUserGroupId(l12);
            if (cej2.h(userRole, this.a) != 1L) continue;
            cej2.e(userRole, this.a);
            String string = "Removed userId " + l10 + " from userGroup " + l12;
            akh.ac().a(this.a, l11, 2001, string, l10, "userid", 0L, null);
        }
        bxc.a(l11);
    }
}

