/*
 * Decompiled with CFR 0.152.
 */
package secauth;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import secauth.ai6;
import secauth.aqm;
import secauth.b11;
import secauth.b1_;
import secauth.b1x;
import secauth.b1z;
import secauth.b3;
import secauth.b_c;
import secauth.bvw;
import secauth.bwe;
import secauth.bwx;
import secauth.bxt;
import secauth.bxv;
import secauth.byc;
import secauth.bye;
import secauth.cal;
import secauth.cam;
import secauth.can;
import secauth.cbl;
import secauth.cd;
import secauth.n3;
import seccommerce.mobile.bo.CntReqStatusType;
import seccommerce.mobile.bo.SecSignID;
import seccommerce.secpki.bo.ContactDirEntry;
import seccommerce.secpki.bo.ContactDirGroup;
import seccommerce.user.bo.IdProfile;
import seccommerce.user.bo.VisibilityType;

@b1z(a=b1_.IDSERVER, b=b11.REQUEST)
public class bvs {
    @b1x
    private bvw a;
    @b1x
    private byc b;
    @b1x
    private bye c;
    @b1x
    private bwe d;
    @b1x
    private bwx e;
    @b1x
    private bxv f;

    public can a(@NotNull Long l10, @NotNull Long l11, @NotNull Long l12) throws aqm, ai6 {
        Objects.requireNonNull(l10, () -> "ContactDirEntryCollectorService: Cannot getContactDirEntryForUser: orgId is null");
        Objects.requireNonNull(l11, () -> "ContactDirEntryCollectorService: Cannot getContactDirEntryForUser: userIdId is null");
        Objects.requireNonNull(l12, () -> "ContactDirEntryCollectorService: Cannot getContactDirEntryForUser: contactDirEntryId is null");
        List<can> list = this.a(bxt.a(l10, l11, l12));
        if (list.isEmpty()) {
            throw new aqm("ContactDirEntryCollectorService: Did not find any contact directory entry for contactDirEntryId " + l12);
        }
        if (list.size() > 1) {
            throw new aqm("ContactDirEntryCollectorService: Found " + list.size() + "  contact directory entries for contactDirEntryId " + l12 + " - Expected exactly one!");
        }
        return list.get(0);
    }

    public List<can> a(@NotNull Long l10) throws aqm, ai6 {
        Objects.requireNonNull(l10, "getAllAcceptedContacts: userIdId must not be null");
        List<cam> list = this.f.b(l10);
        return this.a(l10, list);
    }

    public List<can> b(@NotNull Long l10) throws aqm, ai6 {
        Objects.requireNonNull(l10, "getAllContactsForRejectedContactRequest: userIdId must not be null");
        List<cam> list = this.f.d(l10);
        this.a(list);
        return this.a(l10, list);
    }

    public List<can> c(@NotNull Long l10) throws aqm, ai6 {
        Objects.requireNonNull(l10, "getAllContactsForPendingContactRequests: userIdId must not be null");
        List<cam> list = this.f.c(l10);
        this.a(list);
        return this.a(l10, list);
    }

    private final void a(@NotNull List<cam> list) {
        Objects.requireNonNull(list, "setStatusToAccepted: contactRequests must not be null");
        list.forEach(cam2 -> cam2.a(CntReqStatusType.ai));
    }

    private final List<can> a(@NotNull Long l11, @NotNull List<cam> list) throws aqm, ai6 {
        Objects.requireNonNull(l11, "readFromIdProfileWithoutContactDirEntry: userIdId must not be null");
        Objects.requireNonNull(list, "readFromIdProfileWithoutContactDirEntry: contactRequests must not be null");
        List<ContactDirEntry> list2 = list.stream().map(cam2 -> this.a(l11, (cam)cam2)).map(l10 -> {
            ContactDirEntry contactDirEntry = new ContactDirEntry();
            contactDirEntry.e(1L);
            contactDirEntry.b((Long)l10);
            return contactDirEntry;
        }).collect(Collectors.toList());
        return this.a(l11, list2, list);
    }

    @NotNull
    private final Long a(@NotNull Long l10, @NotNull cam cam2) {
        Objects.requireNonNull(l10, "getContactUserIdId: userIdId must not be null");
        Objects.requireNonNull(cam2, "getContactUserIdId: contactRequest must not be null");
        if (cam2.b().equals(l10)) {
            return cam2.c();
        }
        return cam2.b();
    }

    public List<can> b(@NotNull Long l10, @NotNull Long l11, @NotNull Long l12) throws aqm, ai6 {
        Objects.requireNonNull(l10, () -> "ContactDirEntryCollectorService: Cannot getContactDirEntriesForUser orgId is null");
        Objects.requireNonNull(l11, () -> "ContactDirEntryCollectorService: Cannot getContactDirEntriesForUser userIdId is null");
        Objects.requireNonNull(l12, () -> "ContactDirEntryCollectorService: Cannot getContactDirEntriesForUser contactDirectoryId is null");
        return this.a(bxt.b(l10, l11, l12));
    }

    public List<can> a(@NotNull Long l10, @NotNull Long l11) throws aqm, ai6 {
        return this.a(bxt.a(l10, l11));
    }

    public List<can> c(@NotNull Long l10, @NotNull Long l11, @NotNull Long l12) throws aqm, ai6 {
        return this.a(bxt.c(l10, l11, l12));
    }

    private final List<can> a(@NotNull bxt bxt2) throws aqm, ai6 {
        Objects.requireNonNull(bxt2, "Cannot getEntries: query is null");
        n3.f("ContactDirEntryCollectorService: Getting all contact directories user " + bxt2.b() + " is allowed to see");
        List<cal> list = this.d(bxt2);
        List<Long> list2 = list.stream().map(cal::a).collect(Collectors.toList());
        List<ContactDirEntry> list3 = this.a(bxt2, list2);
        List<can> list4 = this.b(bxt2.b(), list3);
        for (can can2 : list4) {
            cal cal3 = list.stream().filter(cal2 -> cal2.a().equals(can2.l())).findFirst().orElseThrow(() -> new aqm("ContactDirEntryCollectorService: Did not find contact directory for ContactDirEntry " + can2.k()));
            can2.h(cal3.b());
        }
        return list4;
    }

    @NotNull
    private final List<can> b(@NotNull Long l10, @NotNull List<ContactDirEntry> list) throws aqm, ai6 {
        Objects.requireNonNull(l10, () -> "ContactDirEntryCollectorService: Cannot enrichContactsWithIdProfileData: contactResultTO is null");
        Objects.requireNonNull(list, () -> "ContactDirEntryCollectorService: Cannot enrichContactsWithIdProfileData: contactResultTO is null");
        Map<Boolean, List<ContactDirEntry>> map = list.stream().collect(Collectors.partitioningBy(contactDirEntry -> contactDirEntry.g() != null));
        List<ContactDirEntry> list2 = map.get(Boolean.FALSE);
        n3.f("ContactDirEntryCollectorService: Found " + list2.size() + " external contacts for userIdId " + l10);
        List<ContactDirEntry> list3 = map.get(Boolean.TRUE);
        n3.f("ContactDirEntryCollectorService: Found " + list3.size() + " internal contacts for userIdId " + l10);
        Supplier<can> supplier = cbl.a(list2, can::new);
        if (!list3.isEmpty()) {
            List<cam> list4 = this.f.a(l10);
            supplier.addAll(this.a(l10, list3, list4));
        }
        return supplier;
    }

    @NotNull
    private final List<ContactDirEntry> a(@NotNull bxt bxt2, @NotNull List<Long> list) throws aqm {
        List<ContactDirEntry> list2;
        Objects.requireNonNull(bxt2, () -> "ContactDirEntryCollectorService: Cannot loadContactDirEntries: query is null");
        Objects.requireNonNull(list, () -> "ContactDirEntryCollectorService: Cannot loadContactDirEntries: contactDirectoryIds is null");
        switch (bxt2.f()) {
            case a: {
                list2 = this.b(bxt2);
                break;
            }
            case b: {
                list2 = this.c(bxt2);
                break;
            }
            case c: 
            case d: {
                list2 = this.b(list);
                break;
            }
            default: {
                throw new IllegalStateException("ContactDirEntryCollectorService: Could not load contact directory entries: Given query object uses an unknown mode");
            }
        }
        n3.f("ContactDirEntryCollectorService: Checking if a userIdId needs to be set for any found ContactDirEntry");
        this.d(bxt2.a(), list2.stream().filter(contactDirEntry -> contactDirEntry.e() != null || contactDirEntry.g() != null).collect(Collectors.toList()));
        return list2;
    }

    @NotNull
    private final List<ContactDirEntry> b(@NotNull bxt bxt2) throws aqm {
        Objects.requireNonNull(bxt2, "loadSingleContactDirEntry: query must not be null");
        try {
            n3.f("ContactDirEntryCollectorService: Getting single ContactDirEntry " + bxt2.d());
            if (bxt2.d() == null) {
                throw new aqm("ContactDirEntryCollectorService: Unexpected error: query.getEntryId is null even though mode is ENTRY");
            }
            assert (bxt2.d() != null);
            return Collections.singletonList(this.b.a(bxt2.d()));
        }
        catch (b_c b_c2) {
            throw new aqm("ContactDirEntryCollectorService: Error while trying to get contactDirEntry " + bxt2.d(), b_c2);
        }
    }

    @NotNull
    private final List<ContactDirEntry> c(@NotNull bxt bxt2) throws aqm {
        Objects.requireNonNull(bxt2, "loadGroupContactDirEntries: query must not be null");
        try {
            n3.g("ContactDirEntryCollectorService: Getting ContactDirEntries for group " + bxt2.e());
            if (bxt2.e() == null) {
                throw new aqm("ContactDirEntryCollectorService: Unexpected error: query.getGroupId is null even though mode is GROUP");
            }
            assert (bxt2.e() != null);
            return this.b.b(Collections.singleton(bxt2.e()));
        }
        catch (b_c b_c2) {
            throw new aqm("ContactDirEntryCollectorService: Error while trying to get ContactDirEntries for group " + bxt2.e(), b_c2);
        }
    }

    @NotNull
    private final List<ContactDirEntry> b(@NotNull List<Long> list) throws aqm {
        Objects.requireNonNull(list, "loadDirectoryContactDirEntries: contactDirectoryIds must not be null");
        try {
            n3.f("ContactDirEntryCollectorService: Getting all ContactDirEntries from directories " + list);
            return this.b.b(list);
        }
        catch (b_c b_c2) {
            throw new aqm("ContactDirEntryCollectorService: Error while trying to get contact directories", b_c2);
        }
    }

    @NotNull
    private final List<cal> d(@NotNull bxt bxt2) throws aqm {
        Objects.requireNonNull(bxt2, "Cannot getContactDirectory: query is null");
        switch (bxt2.f()) {
            case c: {
                return this.e(bxt2);
            }
            case a: {
                return this.f(bxt2);
            }
            case b: {
                return this.g(bxt2);
            }
            case d: {
                return this.h(bxt2);
            }
        }
        throw new IllegalStateException("ContactDirEntryCollectorService: Could not load contact directories: Given query object uses an unknown mode");
    }

    @NotNull
    private final List<cal> e(@NotNull bxt bxt2) throws aqm {
        Objects.requireNonNull(bxt2, "getContactDirectoryById: query must not be null");
        if (bxt2.c() == null) {
            throw new aqm("ContactDirEntryCollectorService: Unexpected error: query.getDirectoryId is null even though mode is DIRECTORY");
        }
        assert (bxt2.c() != null);
        return Collections.singletonList(this.a.a(bxt2.a(), bxt2.b(), bxt2.c()));
    }

    @NotNull
    private final List<cal> f(@NotNull bxt bxt2) throws aqm {
        Objects.requireNonNull(bxt2, "getContactDirectoryOfEntry: query must not be null");
        if (bxt2.d() == null) {
            throw new aqm("ContactDirEntryCollectorService: Unexpected error: query.getEntryId is null even though mode is ENTRY");
        }
        assert (bxt2.d() != null);
        return Collections.singletonList(this.a.b(bxt2.a(), bxt2.b(), bxt2.d()));
    }

    @NotNull
    private final List<cal> g(@NotNull bxt bxt2) throws aqm {
        ContactDirGroup contactDirGroup;
        Objects.requireNonNull(bxt2, "getContactDirectoryOfGroup: query must not be null");
        if (bxt2.e() == null) {
            throw new aqm("ContactDirEntryCollectorService: Unexpected error: query.getGroupId is null even though mode is GROUP");
        }
        assert (bxt2.e() != null);
        try {
            contactDirGroup = (ContactDirGroup)this.c.a(bxt2.e());
        }
        catch (b_c b_c2) {
            throw new aqm("Error while reading ContactDirGroup with id " + bxt2.e(), b_c2);
        }
        return Collections.singletonList(this.a.a(bxt2.a(), bxt2.b(), contactDirGroup.c()));
    }

    @NotNull
    private final List<cal> h(@NotNull bxt bxt2) throws aqm {
        Objects.requireNonNull(bxt2, "getAllContactDirectories: query must not be null");
        List<cal> list = this.a.a(bxt2.a(), bxt2.b());
        if (list.isEmpty()) {
            n3.f("ContactDirEntryCollectorService: User " + bxt2.b() + " is not allowed to see any contact directories");
            return Collections.emptyList();
        }
        return list;
    }

    private final List<can> a(@NotNull Long l10, @NotNull List<ContactDirEntry> list, @NotNull List<cam> list2) throws aqm, ai6 {
        Objects.requireNonNull(l10, () -> "ContactDirEntryCollectorService: Cannot readFromIdProfile: userIdId is null");
        Objects.requireNonNull(list, () -> "ContactDirEntryCollectorService: Cannot readFromIdProfile: internalContacts is null");
        Objects.requireNonNull(list2, () -> "ContactDirEntryCollectorService: Cannot readFromIdProfile: contactRequestList is null");
        Map<Long, cam> map = bvs.c(l10, list2);
        Set set = list.stream().map(ContactDirEntry::g).collect(Collectors.toSet());
        Map map2 = this.d.a(new HashSet<Long>(set)).stream().collect(Collectors.toMap(IdProfile::getUserIdId, Function.identity()));
        ArrayList<can> arrayList = new ArrayList<can>();
        for (ContactDirEntry contactDirEntry : list) {
            cam cam2 = map.getOrDefault(contactDirEntry.g(), null);
            if (cam2 == null) {
                n3.f("ContactDirEntryCollectorService: Found no accepted contactRequest between " + l10 + " and " + contactDirEntry.g() + " - using only public IdProfile data");
            } else {
                n3.f("ContactDirEntryCollectorService: Found " + cam2 + " for ContactDirEntry " + contactDirEntry.u());
            }
            IdProfile idProfile = map2.getOrDefault(contactDirEntry.g(), null);
            if (idProfile == null) {
                throw new aqm("ContactDirEntryCollectorService: Expected to find IdProfile for ContactDirEntry " + contactDirEntry.u() + " with userIdId " + contactDirEntry.g());
            }
            n3.f("ContactDirEntryCollectorService: Found IdProfile " + idProfile.getId() + " for ContactDirEntry " + contactDirEntry.u());
            can can2 = cbl.a(contactDirEntry, new can());
            if (bvs.a(idProfile, cam2) || l10.equals(contactDirEntry.g())) {
                bvs.a(can2, idProfile);
            }
            if (cam2 != null) {
                can2.b(cam2.a());
                can2.c(cam2.d());
                if (CntReqStatusType.ai.equals(cam2.d()) || l10.equals(contactDirEntry.g())) {
                    bvs.b(can2, idProfile);
                }
            }
            if (VisibilityType.PRIVATE.equals(idProfile.getPrfVisibility()) && (cam2 == null || !CntReqStatusType.ai.equals(cam2.d()))) {
                can2.a((Long)null);
                can2.a((String)null);
                can2.b((Long)null);
                can2.c((Long)null);
            }
            arrayList.add(can2);
        }
        return arrayList;
    }

    private static Map<Long, cam> c(Long l10, List<cam> list) {
        HashMap<Long, cam> hashMap = new HashMap<Long, cam>();
        for (cam cam2 : list) {
            Long l11 = cam2.b().equals(l10) ? cam2.c() : cam2.b();
            hashMap.put(l11, cam2);
        }
        return hashMap;
    }

    private static boolean a(@NotNull IdProfile idProfile, @Nullable cam cam2) {
        Objects.requireNonNull(idProfile, () -> "ContactDirEntryCollectorService: Cannot isReadingPublicProfileDataAllowed: idProfile is null");
        return VisibilityType.PUBLIC.equals(idProfile.getPrfVisibility()) || cam2 != null && CntReqStatusType.ai.equals(cam2.d());
    }

    private static void a(@NotNull can can2, @NotNull IdProfile idProfile) {
        Objects.requireNonNull(can2, () -> "ContactDirEntryCollectorService: Cannot setPublicProfileData: contactResultTO is null");
        Objects.requireNonNull(idProfile, () -> "ContactDirEntryCollectorService: Cannot setPublicProfileData: idProfile is null");
        n3.f("ContactDirEntryCollectorService: Setting public values from IdProfile for ContactResultTO for ContactDirEntry " + can2.k());
        can2.a(Boolean.TRUE);
        can2.b(Boolean.TRUE);
        can2.c(Boolean.TRUE);
        can2.d(Boolean.TRUE);
        can2.e(Boolean.TRUE);
        can2.f(Boolean.TRUE);
        can2.g(Boolean.TRUE);
        if (can2.b() != null && can2.b().equals(idProfile.getEmailAddress())) {
            can2.a(Boolean.FALSE);
        }
        if (VisibilityType.PUBLIC.equals(idProfile.getEmailAddrVisib()) && cd.t(idProfile.getEmailAddress())) {
            can2.b(idProfile.getEmailAddress());
            can2.a(Boolean.FALSE);
        }
        if (VisibilityType.PUBLIC.equals(idProfile.getTitleVisib()) && cd.t(idProfile.getTitle())) {
            can2.c(idProfile.getTitle());
            can2.b(Boolean.FALSE);
        }
        if (VisibilityType.PUBLIC.equals(idProfile.getFirstNameVisib()) && cd.t(idProfile.getFirstName())) {
            can2.d(idProfile.getFirstName());
            can2.c(Boolean.FALSE);
        }
        if (VisibilityType.PUBLIC.equals(idProfile.getLastNameVisib()) && cd.t(idProfile.getLastName())) {
            can2.e(idProfile.getLastName());
            can2.d(Boolean.FALSE);
        }
        if (VisibilityType.PUBLIC.equals(idProfile.getDepartmentVisi()) && cd.t(idProfile.getDepartment())) {
            can2.f(idProfile.getDepartment());
            can2.e(Boolean.FALSE);
        }
        if (VisibilityType.PUBLIC.equals(idProfile.getCompanyNamVisi()) && cd.t(idProfile.getCompanyName())) {
            can2.g(idProfile.getCompanyName());
            can2.f(Boolean.FALSE);
        }
        if (VisibilityType.PUBLIC.equals(idProfile.getMbilPhnNrVisi()) && cd.t(idProfile.getMobilePhoneNr()) && idProfile.getMobilPhoneNrVerifd().booleanValue()) {
            can2.i(b3.b(idProfile.getMobilePhoneNr()).d());
            can2.g(Boolean.FALSE);
        }
    }

    private static void b(@NotNull can can2, @NotNull IdProfile idProfile) {
        Objects.requireNonNull(can2, () -> "ContactDirEntryCollectorService: Cannot setContactSharedProfileData: contactResultTO is null");
        Objects.requireNonNull(idProfile, () -> "ContactDirEntryCollectorService: Cannot setContactSharedProfileData: idProfile is null");
        n3.f("ContactDirEntryCollectorService: Setting contact shared values from IdProfile for ContactResultTO for ContactDirEntry " + can2.k());
        if (VisibilityType.CONTACTS.equals(idProfile.getEmailAddrVisib()) && cd.t(idProfile.getEmailAddress())) {
            can2.b(idProfile.getEmailAddress());
            can2.a(Boolean.FALSE);
        }
        if (VisibilityType.CONTACTS.equals(idProfile.getTitleVisib()) && cd.t(idProfile.getTitle())) {
            can2.c(idProfile.getTitle());
            can2.b(Boolean.FALSE);
        }
        if (VisibilityType.CONTACTS.equals(idProfile.getFirstNameVisib()) && cd.t(idProfile.getFirstName())) {
            can2.d(idProfile.getFirstName());
            can2.c(Boolean.FALSE);
        }
        if (VisibilityType.CONTACTS.equals(idProfile.getLastNameVisib()) && cd.t(idProfile.getLastName())) {
            can2.e(idProfile.getLastName());
            can2.d(Boolean.FALSE);
        }
        if (VisibilityType.CONTACTS.equals(idProfile.getDepartmentVisi()) && cd.t(idProfile.getDepartment())) {
            can2.f(idProfile.getDepartment());
            can2.e(Boolean.FALSE);
        }
        if (VisibilityType.CONTACTS.equals(idProfile.getCompanyNamVisi()) && cd.t(idProfile.getCompanyName())) {
            can2.g(idProfile.getCompanyName());
            can2.f(Boolean.FALSE);
        }
        if (VisibilityType.CONTACTS.equals(idProfile.getMbilPhnNrVisi()) && cd.t(idProfile.getMobilePhoneNr()) && idProfile.getMobilPhoneNrVerifd().booleanValue()) {
            can2.i(b3.b(idProfile.getMobilePhoneNr()).d());
            can2.g(Boolean.FALSE);
        }
    }

    private final void d(@NotNull Long l10, @NotNull List<ContactDirEntry> list) throws aqm {
        Objects.requireNonNull(l10, () -> "ContactDirEntryCollectorService: Cannot setUserIdIdForSecSignId: orgId is null");
        Objects.requireNonNull(list, () -> "ContactDirEntryCollectorService: Cannot setUserIdIdForSecSignId: entries is null");
        if (list.isEmpty()) {
            return;
        }
        for (ContactDirEntry contactDirEntry : list) {
            if (contactDirEntry.g() != null && cd.t(contactDirEntry.e())) {
                n3.f("ContactDirEntryCollectorService: Not setting a userIdId/secSignId for ContactDirEntry " + contactDirEntry.u() + " because both are already set");
                continue;
            }
            if (contactDirEntry.g() == null && cd.s(contactDirEntry.e())) {
                n3.f("ContactDirEntryCollectorService: Not setting a userIdId/secSignId for ContactDirEntry " + contactDirEntry.u() + " because both are not set");
                continue;
            }
            SecSignID secSignID = null;
            if (contactDirEntry.g() == null) {
                try {
                    secSignID = this.e.a(contactDirEntry.e(), l10, false);
                }
                catch (aqm aqm2) {
                    throw new aqm("Error while trying to get userIdId for SecSignId " + contactDirEntry.e(), aqm2);
                }
            }
            if (cd.s(contactDirEntry.e())) {
                try {
                    secSignID = this.e.a(contactDirEntry.g(), l10);
                }
                catch (SQLException sQLException) {
                    throw new aqm("Error while trying to get SecSignId for userIdId " + contactDirEntry.g(), sQLException);
                }
            }
            if (secSignID == null) {
                n3.b("ContactDirEntryCollectorService: Could not find SecSignId for ContactDirEntry " + contactDirEntry.u() + " with userIdId " + contactDirEntry.g() + " and SecSignId " + contactDirEntry.e());
                continue;
            }
            contactDirEntry.b(secSignID.i());
            contactDirEntry.d(secSignID.b());
            try {
                n3.f("ContactDirEntryCollectorService: Setting userIdId " + secSignID.i() + " for ContactDirEntry " + contactDirEntry.u());
                this.b.a(contactDirEntry.u(), secSignID.i(), secSignID.b());
            }
            catch (b_c b_c2) {
                throw new aqm("Error while trying to set userIdId " + secSignID.i() + " and SecSignId" + secSignID.b() + " for ContactDirEntry " + contactDirEntry.u(), b_c2);
            }
        }
    }
}

